/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.annotation.DisableOnCondition;
import run.halo.app.mail.MailService;
import run.halo.app.model.params.MailParam;
import run.halo.app.model.support.BaseResponse;

@RestController
@RequestMapping(value={"/api/admin/mails"})
public class MailController {
    private final MailService mailService;

    public MailController(MailService mailService) {
        this.mailService = mailService;
    }

    @PostMapping(value={"test"})
    @ApiOperation(value="Tests the SMTP service")
    @DisableOnCondition
    public BaseResponse<String> testMail(@Valid @RequestBody MailParam mailParam) {
        this.mailService.sendTextMail(mailParam.getTo(), mailParam.getSubject(), mailParam.getContent());
        return BaseResponse.ok((String)"\u5df2\u53d1\u9001\uff0c\u8bf7\u67e5\u6536\u3002\u82e5\u786e\u8ba4\u6ca1\u6709\u6536\u5230\u90ae\u4ef6\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u65e5\u5fd7");
    }

    @PostMapping(value={"test/connection"})
    @ApiOperation(value="Test connection with email server")
    @DisableOnCondition
    public BaseResponse<String> testConnection() {
        this.mailService.testConnection();
        return BaseResponse.ok((String)"\u60a8\u548c\u90ae\u7bb1\u670d\u52a1\u5668\u7684\u8fde\u63a5\u901a\u7545");
    }
}

