/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.MenuDTO;
import run.halo.app.model.dto.base.InputConverter;
import run.halo.app.model.entity.Menu;
import run.halo.app.model.params.MenuParam;
import run.halo.app.model.vo.MenuVO;
import run.halo.app.service.MenuService;

@RestController
@RequestMapping(value={"/api/admin/menus"})
public class MenuController {
    private final MenuService menuService;

    public MenuController(MenuService menuService) {
        this.menuService = menuService;
    }

    @GetMapping
    @ApiOperation(value="Lists all menus")
    public List<MenuDTO> listAll(@SortDefault(sort={"team"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.menuService.listDtos(sort.and(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"priority"})));
    }

    @GetMapping(value={"tree_view"})
    @ApiOperation(value="Lists menus as tree")
    public List<MenuVO> listAsTree(@SortDefault(sort={"team"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.menuService.listAsTree(sort.and(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"priority"})));
    }

    @GetMapping(value={"team/tree_view"})
    @ApiOperation(value="Lists menus as tree by team")
    public List<MenuVO> listDefaultsAsTreeByTeam(@SortDefault(sort={"priority"}, direction=Sort.Direction.ASC) Sort sort, @RequestParam(name="team") String team) {
        return this.menuService.listByTeamAsTree(team, sort);
    }

    @GetMapping(value={"{menuId:\\d+}"})
    @ApiOperation(value="Gets menu detail by id")
    public MenuDTO getBy(@PathVariable(value="menuId") Integer menuId) {
        return (MenuDTO)new MenuDTO().convertFrom((Object)((Menu)this.menuService.getById((Object)menuId)));
    }

    @PostMapping
    @ApiOperation(value="Creates a menu")
    public MenuDTO createBy(@RequestBody @Valid MenuParam menuParam) {
        return (MenuDTO)new MenuDTO().convertFrom((Object)this.menuService.createBy(menuParam));
    }

    @PostMapping(value={"/batch"})
    public List<MenuDTO> createBatchBy(@RequestBody @Valid List<MenuParam> menuParams) {
        List menus = menuParams.stream().map(InputConverter::convertTo).collect(Collectors.toList());
        return this.menuService.createInBatch(menus).stream().map(menu -> (MenuDTO)new MenuDTO().convertFrom(menu)).collect(Collectors.toList());
    }

    @PutMapping(value={"{menuId:\\d+}"})
    @ApiOperation(value="Updates a menu")
    public MenuDTO updateBy(@PathVariable(value="menuId") Integer menuId, @RequestBody @Valid MenuParam menuParam) {
        Menu menu = (Menu)this.menuService.getById((Object)menuId);
        menuParam.update((Object)menu);
        return (MenuDTO)new MenuDTO().convertFrom((Object)((Menu)this.menuService.update((Object)menu)));
    }

    @PutMapping(value={"/batch"})
    public List<MenuDTO> updateBatchBy(@RequestBody @Valid List<MenuParam> menuParams) {
        List menus = menuParams.stream().filter(menuParam -> Objects.nonNull(menuParam.getId())).map(InputConverter::convertTo).collect(Collectors.toList());
        return this.menuService.updateInBatch(menus).stream().map(menu -> (MenuDTO)new MenuDTO().convertFrom(menu)).collect(Collectors.toList());
    }

    @DeleteMapping(value={"{menuId:\\d+}"})
    @ApiOperation(value="Deletes a menu")
    public MenuDTO deleteBy(@PathVariable(value="menuId") Integer menuId) {
        List menus = this.menuService.listByParentId(menuId);
        if (null != menus && menus.size() > 0) {
            menus.forEach(menu -> {
                menu.setParentId(Integer.valueOf(0));
                this.menuService.update(menu);
            });
        }
        return (MenuDTO)new MenuDTO().convertFrom((Object)((Menu)this.menuService.removeById((Object)menuId)));
    }

    @DeleteMapping(value={"/batch"})
    public List<MenuDTO> deleteBatchBy(@RequestBody List<Integer> menuIds) {
        List menus = this.menuService.listAllByIds(menuIds);
        this.menuService.removeInBatch(menuIds);
        return menus.stream().map(menu -> (MenuDTO)new MenuDTO().convertFrom(menu)).collect(Collectors.toList());
    }

    @GetMapping(value={"teams"})
    @ApiOperation(value="Lists all menu teams")
    public List<String> teams() {
        return this.menuService.listAllTeams();
    }
}

