/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.BadRequestException;
import run.halo.app.model.enums.MigrateType;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.service.MigrateService;
import run.halo.app.service.OptionService;

@RestController
@RequestMapping(value={"/api/admin/migrations"})
public class MigrateController {
    private final MigrateService migrateService;
    private final OptionService optionService;

    public MigrateController(MigrateService migrateService, OptionService optionService) {
        this.migrateService = migrateService;
        this.optionService = optionService;
    }

    @PostMapping(value={"halo"})
    @ApiOperation(value="Migrate from Halo")
    public void migrateHalo(@RequestPart(value="file") MultipartFile file) {
        if (((Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.IS_INSTALLED, Boolean.class, (Object)false)).booleanValue()) {
            throw new BadRequestException("\u65e0\u6cd5\u5728\u535a\u5ba2\u521d\u59cb\u5316\u5b8c\u6210\u4e4b\u540e\u8fc1\u79fb\u6570\u636e");
        }
        this.migrateService.migrate(file, MigrateType.HALO);
    }
}

