/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.annotation.DisableOnCondition;
import run.halo.app.model.dto.OptionDTO;
import run.halo.app.model.dto.OptionSimpleDTO;
import run.halo.app.model.entity.Option;
import run.halo.app.model.params.OptionParam;
import run.halo.app.model.params.OptionQuery;
import run.halo.app.service.OptionService;

@RestController
@RequestMapping(value={"/api/admin/options"})
public class OptionController {
    private final OptionService optionService;

    public OptionController(OptionService optionService) {
        this.optionService = optionService;
    }

    @GetMapping
    @ApiOperation(value="Lists options")
    public List<OptionDTO> listAll() {
        return this.optionService.listDtos();
    }

    @PostMapping(value={"saving"})
    @ApiOperation(value="Saves options")
    @DisableOnCondition
    public void saveOptions(@Valid @RequestBody List<OptionParam> optionParams) {
        this.optionService.save(optionParams);
    }

    @GetMapping(value={"map_view"})
    @ApiOperation(value="Lists all options with map view")
    public Map<String, Object> listAllWithMapView() {
        return this.optionService.listOptions();
    }

    @PostMapping(value={"map_view/keys"})
    @ApiOperation(value="Lists options with map view by keys")
    public Map<String, Object> listAllWithMapView(@RequestBody List<String> keys) {
        return this.optionService.listOptions(keys);
    }

    @GetMapping(value={"list_view"})
    @ApiOperation(value="Lists all options with list view")
    public Page<OptionSimpleDTO> listAllWithListView(@PageableDefault(sort={"updateTime"}, direction=Sort.Direction.DESC) Pageable pageable, OptionQuery optionQuery) {
        return this.optionService.pageDtosBy(pageable, optionQuery);
    }

    @GetMapping(value={"{id:\\d+}"})
    @ApiOperation(value="Gets option detail by id")
    public OptionSimpleDTO getBy(@PathVariable(value="id") Integer id) {
        Option option = (Option)this.optionService.getById((Object)id);
        return this.optionService.convertToDto(option);
    }

    @PostMapping
    @ApiOperation(value="Creates option")
    @DisableOnCondition
    public void createBy(@RequestBody @Valid OptionParam optionParam) {
        this.optionService.save(optionParam);
    }

    @PutMapping(value={"{optionId:\\d+}"})
    @ApiOperation(value="Updates option")
    @DisableOnCondition
    public void updateBy(@PathVariable(value="optionId") Integer optionId, @RequestBody @Valid OptionParam optionParam) {
        this.optionService.update(optionId, optionParam);
    }

    @DeleteMapping(value={"{optionId:\\d+}"})
    @ApiOperation(value="Deletes option")
    @DisableOnCondition
    public void deletePermanently(@PathVariable(value="optionId") Integer optionId) {
        this.optionService.removePermanently(optionId);
    }

    @PostMapping(value={"map_view/saving"})
    @ApiOperation(value="Saves options by option map")
    @DisableOnCondition
    public void saveOptionsWithMapView(@RequestBody Map<String, Object> optionMap) {
        this.optionService.save(optionMap);
    }
}

