/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.cache.lock.CacheParam;
import run.halo.app.model.dto.PhotoDTO;
import run.halo.app.model.entity.Photo;
import run.halo.app.model.params.PhotoParam;
import run.halo.app.model.params.PhotoQuery;
import run.halo.app.service.PhotoService;

@Validated
@RestController
@RequestMapping(value={"/api/admin/photos"})
public class PhotoController {
    private final PhotoService photoService;

    public PhotoController(PhotoService photoService) {
        this.photoService = photoService;
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="Lists latest photos")
    public List<PhotoDTO> listPhotos(@SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.photoService.listDtos(sort);
    }

    @GetMapping
    @ApiOperation(value="Lists photos")
    public Page<PhotoDTO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable, PhotoQuery photoQuery) {
        return this.photoService.pageDtosBy(pageable, photoQuery);
    }

    @GetMapping(value={"{photoId:\\d+}"})
    @ApiOperation(value="Gets photo detail by id")
    public PhotoDTO getBy(@PathVariable(value="photoId") Integer photoId) {
        return (PhotoDTO)new PhotoDTO().convertFrom((Object)((Photo)this.photoService.getById((Object)photoId)));
    }

    @DeleteMapping(value={"{photoId:\\d+}"})
    @ApiOperation(value="Deletes photo by id")
    public void deletePermanently(@PathVariable(value="photoId") Integer photoId) {
        this.photoService.removeById((Object)photoId);
    }

    @DeleteMapping(value={"/batch"})
    @ApiOperation(value="Deletes photos permanently in batch by id array")
    public List<PhotoDTO> deletePermanentlyInBatch(@RequestBody List<Integer> ids) {
        return ids.stream().map(arg_0 -> ((PhotoService)this.photoService).removeById(arg_0)).map(photo -> (PhotoDTO)new PhotoDTO().convertFrom(photo)).collect(Collectors.toList());
    }

    @PostMapping
    @ApiOperation(value="Creates a photo")
    public PhotoDTO createBy(@Valid @RequestBody PhotoParam photoParam) {
        return (PhotoDTO)new PhotoDTO().convertFrom((Object)this.photoService.createBy(photoParam));
    }

    @PostMapping(value={"/batch"})
    @ApiOperation(value="Batch creation photos")
    public List<PhotoDTO> createBatchBy(@RequestBody List<@Valid PhotoParam> photoParams) {
        return photoParams.stream().map(photoParam -> {
            PhotoDTO photoDto = new PhotoDTO();
            photoDto.convertFrom((Object)this.photoService.createBy(photoParam));
            return photoDto;
        }).collect(Collectors.toList());
    }

    @PutMapping(value={"{photoId:\\d+}"})
    @ApiOperation(value="Updates a photo")
    public PhotoDTO updateBy(@PathVariable(value="photoId") Integer photoId, @RequestBody @Valid PhotoParam photoParam) {
        Photo photo = (Photo)this.photoService.getById((Object)photoId);
        photoParam.update((Object)photo);
        return (PhotoDTO)new PhotoDTO().convertFrom((Object)((Photo)this.photoService.update((Object)photo)));
    }

    @PutMapping(value={"/batch"})
    @ApiOperation(value="Updates photo in batch")
    public List<PhotoDTO> updateBatchBy(@RequestBody List<@Valid PhotoParam> photoParams) {
        List photosToUpdate = photoParams.stream().filter(photoParam -> Objects.nonNull(photoParam.getId())).map(photoParam -> {
            Photo photoToUpdate = (Photo)this.photoService.getById((Object)photoParam.getId());
            photoParam.update((Object)photoToUpdate);
            return photoToUpdate;
        }).collect(Collectors.toList());
        return this.photoService.updateInBatch(photosToUpdate).stream().map(photo -> (PhotoDTO)new PhotoDTO().convertFrom(photo)).collect(Collectors.toList());
    }

    @PutMapping(value={"{photoId:\\d+}/likes"})
    @ApiOperation(value="Likes a photo")
    @CacheLock(autoDelete=false, traceRequest=true)
    public void likes(@PathVariable @CacheParam Integer photoId) {
        this.photoService.increaseLike(photoId);
    }

    @GetMapping(value={"teams"})
    @ApiOperation(value="Lists all of photo teams")
    public List<String> listTeams() {
        return this.photoService.listAllTeams();
    }
}

