/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.params.BaseCommentParam;
import run.halo.app.model.params.CommentQuery;
import run.halo.app.model.params.PostCommentParam;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.model.vo.PostCommentWithPostVO;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.assembler.comment.PostCommentAssembler;

@RestController
@RequestMapping(value={"/api/admin/posts/comments"})
public class PostCommentController {
    private final PostCommentAssembler postCommentAssembler;
    private final PostCommentService postCommentService;
    private final OptionService optionService;

    public PostCommentController(PostCommentAssembler postCommentAssembler, PostCommentService postCommentService, OptionService optionService) {
        this.postCommentAssembler = postCommentAssembler;
        this.postCommentService = postCommentService;
        this.optionService = optionService;
    }

    @GetMapping
    @ApiOperation(value="Lists post comments")
    public Page<PostCommentWithPostVO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable, CommentQuery commentQuery) {
        Page commentPage = this.postCommentService.pageBy(commentQuery, pageable);
        return this.postCommentAssembler.convertToWithPostVo(commentPage);
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="Pages post latest comments")
    public List<PostCommentWithPostVO> listLatest(@RequestParam(name="top", defaultValue="10") int top, @RequestParam(name="status", required=false) CommentStatus status) {
        List content = this.postCommentService.pageLatest(top, status).getContent();
        return this.postCommentAssembler.convertToWithPostVo(content);
    }

    @GetMapping(value={"{postId:\\d+}/tree_view"})
    @ApiOperation(value="Lists post comments with tree view")
    public Page<BaseCommentVO> listCommentTree(@PathVariable(value="postId") Integer postId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.postCommentService.pageVosAllBy(postId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
    }

    @GetMapping(value={"{postId:\\d+}/list_view"})
    @ApiOperation(value="Lists post comment with list view")
    public Page<BaseCommentWithParentVO> listComments(@PathVariable(value="postId") Integer postId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.postCommentService.pageWithParentVoBy(postId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
    }

    @PostMapping
    @ApiOperation(value="Creates a post comment (new or reply)")
    public BaseCommentDTO createBy(@RequestBody PostCommentParam postCommentParam) {
        PostComment createdPostComment = (PostComment)this.postCommentService.createBy((BaseCommentParam)postCommentParam);
        return this.postCommentAssembler.convertTo((BaseComment)createdPostComment);
    }

    @PutMapping(value={"{commentId:\\d+}/status/{status}"})
    @ApiOperation(value="Updates post comment status")
    public BaseCommentDTO updateStatusBy(@PathVariable(value="commentId") Long commentId, @PathVariable(value="status") CommentStatus status) {
        PostComment updatedPostComment = (PostComment)this.postCommentService.updateStatus(commentId, status);
        return this.postCommentAssembler.convertTo((BaseComment)updatedPostComment);
    }

    @PutMapping(value={"status/{status}"})
    @ApiOperation(value="Updates post comment status in batch")
    public List<BaseCommentDTO> updateStatusInBatch(@PathVariable(name="status") CommentStatus status, @RequestBody List<Long> ids) {
        List comments = this.postCommentService.updateStatusByIds(ids, status);
        return this.postCommentAssembler.convertTo(comments);
    }

    @DeleteMapping(value={"{commentId:\\d+}"})
    @ApiOperation(value="Deletes post comment permanently and recursively")
    public BaseCommentDTO deletePermanently(@PathVariable(value="commentId") Long commentId) {
        PostComment deletedPostComment = (PostComment)this.postCommentService.removeById((Object)commentId);
        return this.postCommentAssembler.convertTo((BaseComment)deletedPostComment);
    }

    @DeleteMapping
    @ApiOperation(value="Delete post comments permanently in batch by id array")
    public List<PostComment> deletePermanentlyInBatch(@RequestBody List<Long> ids) {
        return this.postCommentService.removeByIds(ids);
    }

    @GetMapping(value={"{commentId:\\d+}"})
    @ApiOperation(value="Gets a post comment by comment id")
    public PostCommentWithPostVO getBy(@PathVariable(value="commentId") Long commentId) {
        PostComment comment = (PostComment)this.postCommentService.getById((Object)commentId);
        return this.postCommentAssembler.convertToWithPostVo(comment);
    }

    @PutMapping(value={"{commentId:\\d+}"})
    @ApiOperation(value="Updates a post comment")
    public BaseCommentDTO updateBy(@Valid @RequestBody PostCommentParam commentParam, @PathVariable(value="commentId") Long commentId) {
        PostComment commentToUpdate = (PostComment)this.postCommentService.getById((Object)commentId);
        commentParam.update((Object)commentToUpdate);
        return this.postCommentAssembler.convertTo((BaseComment)((PostComment)this.postCommentService.update((Object)commentToUpdate)));
    }
}

