/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.model.dto.post.BasePostDetailDTO;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.dto.post.BasePostSimpleDTO;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Post;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.params.PostContentParam;
import run.halo.app.model.params.PostParam;
import run.halo.app.model.params.PostQuery;
import run.halo.app.model.vo.PostDetailVO;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostService;
import run.halo.app.service.assembler.PostAssembler;
import run.halo.app.utils.HaloUtils;

@RestController
@RequestMapping(value={"/api/admin/posts"})
public class PostController {
    private final PostService postService;
    private final AbstractStringCacheStore cacheStore;
    private final OptionService optionService;
    private final PostAssembler postAssembler;

    public PostController(PostService postService, AbstractStringCacheStore cacheStore, OptionService optionService, PostAssembler postAssembler) {
        this.postService = postService;
        this.cacheStore = cacheStore;
        this.optionService = optionService;
        this.postAssembler = postAssembler;
    }

    @GetMapping
    @ApiOperation(value="Lists posts")
    public Page<? extends BasePostSimpleDTO> pageBy(@PageableDefault(sort={"topPriority", "createTime"}, direction=Sort.Direction.DESC) Pageable pageable, PostQuery postQuery, @RequestParam(value="more", defaultValue="true") Boolean more) {
        Page postPage = this.postService.pageBy(postQuery, pageable);
        if (more.booleanValue()) {
            return this.postAssembler.convertToListVo(postPage);
        }
        return this.postAssembler.convertToSimple(postPage);
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="Pages latest post")
    public List<BasePostMinimalDTO> pageLatest(@RequestParam(name="top", defaultValue="10") int top) {
        return this.postAssembler.convertToMinimal(this.postService.pageLatest(top).getContent());
    }

    @GetMapping(value={"status/{status}"})
    @ApiOperation(value="Gets a page of post by post status")
    public Page<? extends BasePostSimpleDTO> pageByStatus(@PathVariable(name="status") PostStatus status, @RequestParam(value="more", required=false, defaultValue="false") Boolean more, @PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Page posts = this.postService.pageBy(status, pageable);
        if (more.booleanValue()) {
            return this.postAssembler.convertToListVo(posts);
        }
        return this.postAssembler.convertToSimple(posts);
    }

    @GetMapping(value={"{postId:\\d+}"})
    @ApiOperation(value="Gets a post")
    public PostDetailVO getBy(@PathVariable(value="postId") Integer postId) {
        Post post = (Post)this.postService.getWithLatestContentById(postId);
        return this.postAssembler.convertToDetailVo(post);
    }

    @PutMapping(value={"{postId:\\d+}/likes"})
    @ApiOperation(value="Likes a post")
    public void likes(@PathVariable(value="postId") Integer postId) {
        this.postService.increaseLike(postId);
    }

    @PostMapping
    @ApiOperation(value="Creates a post")
    public PostDetailVO createBy(@Valid @RequestBody PostParam postParam, @RequestParam(value="autoSave", required=false, defaultValue="false") Boolean autoSave) {
        Post post = postParam.convertTo();
        return this.postService.createBy(post, postParam.getTagIds(), postParam.getCategoryIds(), postParam.getPostMetas(), autoSave.booleanValue());
    }

    @PutMapping(value={"{postId:\\d+}"})
    @ApiOperation(value="Updates a post")
    public PostDetailVO updateBy(@Valid @RequestBody PostParam postParam, @PathVariable(value="postId") Integer postId, @RequestParam(value="autoSave", required=false, defaultValue="false") Boolean autoSave) {
        Post postToUpdate = (Post)this.postService.getWithLatestContentById(postId);
        postParam.update(postToUpdate);
        return this.postService.updateBy(postToUpdate, postParam.getTagIds(), postParam.getCategoryIds(), postParam.getPostMetas(), autoSave.booleanValue());
    }

    @PutMapping(value={"{postId:\\d+}/status/{status}"})
    @ApiOperation(value="Updates post status")
    public BasePostMinimalDTO updateStatusBy(@PathVariable(value="postId") Integer postId, @PathVariable(value="status") PostStatus status) {
        Post post = (Post)this.postService.updateStatus(status, postId);
        return (BasePostMinimalDTO)new BasePostMinimalDTO().convertFrom((Object)post);
    }

    @PutMapping(value={"status/{status}"})
    @ApiOperation(value="Updates post status in batch")
    public List<Post> updateStatusInBatch(@PathVariable(name="status") PostStatus status, @RequestBody List<Integer> ids) {
        return this.postService.updateStatusByIds(ids, status);
    }

    @PutMapping(value={"{postId:\\d+}/status/draft/content"})
    @ApiOperation(value="Updates draft")
    public BasePostDetailDTO updateDraftBy(@PathVariable(value="postId") Integer postId, @RequestBody PostContentParam contentParam) {
        Post postToUse = (Post)this.postService.getById((Object)postId);
        String formattedContent = contentParam.decideContentBy(postToUse.getEditorType());
        Post post = (Post)this.postService.updateDraftContent(formattedContent, contentParam.getOriginalContent(), postId);
        return this.postAssembler.convertToDetail((BasePost)post);
    }

    @DeleteMapping(value={"{postId:\\d+}"})
    @ApiOperation(value="Deletes a photo permanently")
    public void deletePermanently(@PathVariable(value="postId") Integer postId) {
        this.postService.removeById((Object)postId);
    }

    @DeleteMapping
    @ApiOperation(value="Deletes posts permanently in batch by id array")
    public List<Post> deletePermanentlyInBatch(@RequestBody List<Integer> ids) {
        return this.postService.removeByIds(ids);
    }

    @GetMapping(value={"preview/{postId:\\d+}", "{postId:\\d+}/preview"})
    @ApiOperation(value="Gets a post preview link")
    public String preview(@PathVariable(value="postId") Integer postId) throws UnsupportedEncodingException, URISyntaxException {
        Post post = (Post)this.postService.getById((Object)postId);
        post.setSlug(URLEncoder.encode(post.getSlug(), StandardCharsets.UTF_8.name()));
        BasePostMinimalDTO postMinimalDTO = this.postAssembler.convertToMinimal(post);
        String token = HaloUtils.simpleUUID();
        this.cacheStore.putAny(token, (Object)token, 10L, TimeUnit.MINUTES);
        StringBuilder previewUrl = new StringBuilder();
        if (!this.optionService.isEnabledAbsolutePath().booleanValue()) {
            previewUrl.append(this.optionService.getBlogBaseUrl());
        }
        previewUrl.append(postMinimalDTO.getFullPath());
        return new URIBuilder(previewUrl.toString()).addParameter("token", token).build().toString();
    }
}

