/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.entity.BaseComment;
import run.halo.app.model.entity.SheetComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.params.BaseCommentParam;
import run.halo.app.model.params.CommentQuery;
import run.halo.app.model.params.SheetCommentParam;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.model.vo.SheetCommentWithSheetVO;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.assembler.comment.SheetCommentAssembler;

@RestController
@RequestMapping(value={"/api/admin/sheets/comments"})
public class SheetCommentController {
    private final SheetCommentAssembler sheetCommentAssembler;
    private final SheetCommentService sheetCommentService;
    private final OptionService optionService;

    public SheetCommentController(SheetCommentAssembler sheetCommentAssembler, SheetCommentService sheetCommentService, OptionService optionService) {
        this.sheetCommentAssembler = sheetCommentAssembler;
        this.sheetCommentService = sheetCommentService;
        this.optionService = optionService;
    }

    @GetMapping
    @ApiOperation(value="Lists sheet comments")
    public Page<SheetCommentWithSheetVO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable, CommentQuery commentQuery) {
        Page sheetCommentPage = this.sheetCommentService.pageBy(commentQuery, pageable);
        return this.sheetCommentAssembler.convertToWithSheetVo(sheetCommentPage);
    }

    @GetMapping(value={"latest"})
    @ApiOperation(value="Lists latest sheet comments")
    public List<SheetCommentWithSheetVO> listLatest(@RequestParam(name="top", defaultValue="10") int top, @RequestParam(name="status", required=false) CommentStatus status) {
        Page sheetCommentPage = this.sheetCommentService.pageLatest(top, status);
        return this.sheetCommentAssembler.convertToWithSheetVo(sheetCommentPage.getContent());
    }

    @GetMapping(value={"{sheetId:\\d+}/tree_view"})
    @ApiOperation(value="Lists sheet comments with tree view")
    public Page<BaseCommentVO> listCommentTree(@PathVariable(value="sheetId") Integer sheetId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.sheetCommentService.pageVosAllBy(sheetId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
    }

    @GetMapping(value={"{sheetId:\\d+}/list_view"})
    @ApiOperation(value="Lists sheet comment with list view")
    public Page<BaseCommentWithParentVO> listComments(@PathVariable(value="sheetId") Integer sheetId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.sheetCommentService.pageWithParentVoBy(sheetId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
    }

    @PostMapping
    @ApiOperation(value="Creates a sheet comment (new or reply)")
    public BaseCommentDTO createBy(@RequestBody SheetCommentParam commentParam) {
        SheetComment createdComment = (SheetComment)this.sheetCommentService.createBy((BaseCommentParam)commentParam);
        return this.sheetCommentAssembler.convertTo((BaseComment)createdComment);
    }

    @PutMapping(value={"{commentId:\\d+}/status/{status}"})
    @ApiOperation(value="Updates sheet comment status")
    public BaseCommentDTO updateStatusBy(@PathVariable(value="commentId") Long commentId, @PathVariable(value="status") CommentStatus status) {
        SheetComment updatedSheetComment = (SheetComment)this.sheetCommentService.updateStatus(commentId, status);
        return this.sheetCommentAssembler.convertTo((BaseComment)updatedSheetComment);
    }

    @PutMapping(value={"status/{status}"})
    @ApiOperation(value="Updates sheet comment status in batch")
    public List<BaseCommentDTO> updateStatusInBatch(@PathVariable(name="status") CommentStatus status, @RequestBody List<Long> ids) {
        List comments = this.sheetCommentService.updateStatusByIds(ids, status);
        return this.sheetCommentAssembler.convertTo(comments);
    }

    @DeleteMapping(value={"{commentId:\\d+}"})
    @ApiOperation(value="Deletes sheet comment permanently and recursively")
    public BaseCommentDTO deletePermanently(@PathVariable(value="commentId") Long commentId) {
        SheetComment deletedSheetComment = (SheetComment)this.sheetCommentService.removeById((Object)commentId);
        return this.sheetCommentAssembler.convertTo((BaseComment)deletedSheetComment);
    }

    @DeleteMapping
    @ApiOperation(value="Deletes sheet comments permanently in batch by id array")
    public List<SheetComment> deletePermanentlyInBatch(@RequestBody List<Long> ids) {
        return this.sheetCommentService.removeByIds(ids);
    }

    @GetMapping(value={"{commentId:\\d+}"})
    @ApiOperation(value="Gets a sheet comment by comment id")
    public SheetCommentWithSheetVO getBy(@PathVariable(value="commentId") Long commentId) {
        SheetComment comment = (SheetComment)this.sheetCommentService.getById((Object)commentId);
        return this.sheetCommentAssembler.convertToWithSheetVo(comment);
    }

    @PutMapping(value={"{commentId:\\d+}"})
    @ApiOperation(value="Updates a sheet comment")
    public BaseCommentDTO updateBy(@Valid @RequestBody SheetCommentParam commentParam, @PathVariable(value="commentId") Long commentId) {
        SheetComment commentToUpdate = (SheetComment)this.sheetCommentService.getById((Object)commentId);
        commentParam.update((Object)commentToUpdate);
        return this.sheetCommentAssembler.convertTo((BaseComment)((SheetComment)this.sheetCommentService.update((Object)commentToUpdate)));
    }
}

