/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.model.dto.IndependentSheetDTO;
import run.halo.app.model.dto.post.BasePostDetailDTO;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.params.PostContentParam;
import run.halo.app.model.params.SheetParam;
import run.halo.app.model.vo.SheetDetailVO;
import run.halo.app.model.vo.SheetListVO;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetService;
import run.halo.app.service.assembler.SheetAssembler;
import run.halo.app.utils.HaloUtils;

@RestController
@RequestMapping(value={"/api/admin/sheets"})
public class SheetController {
    private final SheetService sheetService;
    private final AbstractStringCacheStore cacheStore;
    private final OptionService optionService;
    private final SheetAssembler sheetAssembler;

    public SheetController(SheetService sheetService, AbstractStringCacheStore cacheStore, OptionService optionService, SheetAssembler sheetAssembler) {
        this.sheetService = sheetService;
        this.cacheStore = cacheStore;
        this.optionService = optionService;
        this.sheetAssembler = sheetAssembler;
    }

    @GetMapping(value={"{sheetId:\\d+}"})
    @ApiOperation(value="Gets a sheet")
    public SheetDetailVO getBy(@PathVariable(value="sheetId") Integer sheetId) {
        Sheet sheet = (Sheet)this.sheetService.getWithLatestContentById(sheetId);
        return this.sheetAssembler.convertToDetailVo(sheet);
    }

    @GetMapping
    @ApiOperation(value="Gets a page of sheet")
    public Page<SheetListVO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Page sheetPage = this.sheetService.pageBy(pageable);
        return this.sheetAssembler.convertToListVo(sheetPage);
    }

    @GetMapping(value={"independent"})
    @ApiOperation(value="Lists independent sheets")
    public List<IndependentSheetDTO> independentSheets() {
        return this.sheetService.listIndependentSheets();
    }

    @PostMapping
    @ApiOperation(value="Creates a sheet")
    public SheetDetailVO createBy(@RequestBody @Valid SheetParam sheetParam, @RequestParam(value="autoSave", required=false, defaultValue="false") Boolean autoSave) {
        Sheet sheet = this.sheetService.createBy(sheetParam.convertTo(), sheetParam.getSheetMetas(), autoSave.booleanValue());
        return this.sheetAssembler.convertToDetailVo(sheet);
    }

    @PutMapping(value={"{sheetId:\\d+}"})
    @ApiOperation(value="Updates a sheet")
    public SheetDetailVO updateBy(@PathVariable(value="sheetId") Integer sheetId, @RequestBody @Valid SheetParam sheetParam, @RequestParam(value="autoSave", required=false, defaultValue="false") Boolean autoSave) {
        Sheet sheetToUpdate = (Sheet)this.sheetService.getWithLatestContentById(sheetId);
        sheetParam.update(sheetToUpdate);
        Sheet sheet = this.sheetService.updateBy(sheetToUpdate, sheetParam.getSheetMetas(), autoSave.booleanValue());
        return this.sheetAssembler.convertToDetailVo(sheet);
    }

    @PutMapping(value={"{sheetId:\\d+}/{status}"})
    @ApiOperation(value="Updates a sheet")
    public void updateStatusBy(@PathVariable(value="sheetId") Integer sheetId, @PathVariable(value="status") PostStatus status) {
        Sheet sheet = (Sheet)this.sheetService.getById((Object)sheetId);
        sheet.setStatus(status);
        this.sheetService.update((Object)sheet);
    }

    @PutMapping(value={"{sheetId:\\d+}/status/draft/content"})
    @ApiOperation(value="Updates draft")
    public BasePostDetailDTO updateDraftBy(@PathVariable(value="sheetId") Integer sheetId, @RequestBody PostContentParam contentParam) {
        Sheet sheetToUse = (Sheet)this.sheetService.getById((Object)sheetId);
        String formattedContent = contentParam.decideContentBy(sheetToUse.getEditorType());
        Sheet sheet = (Sheet)this.sheetService.updateDraftContent(formattedContent, contentParam.getOriginalContent(), sheetId);
        return this.sheetAssembler.convertToDetail((BasePost)sheet);
    }

    @DeleteMapping(value={"{sheetId:\\d+}"})
    @ApiOperation(value="Deletes a sheet")
    public SheetDetailVO deleteBy(@PathVariable(value="sheetId") Integer sheetId) {
        Sheet sheet = (Sheet)this.sheetService.removeById((Object)sheetId);
        return this.sheetAssembler.convertToDetailVo(sheet);
    }

    @GetMapping(value={"preview/{sheetId:\\d+}"})
    @ApiOperation(value="Gets a sheet preview link")
    public String preview(@PathVariable(value="sheetId") Integer sheetId) throws UnsupportedEncodingException {
        Sheet sheet = (Sheet)this.sheetService.getById((Object)sheetId);
        sheet.setSlug(URLEncoder.encode(sheet.getSlug(), StandardCharsets.UTF_8.name()));
        BasePostMinimalDTO sheetMinimalDTO = this.sheetAssembler.convertToMinimal(sheet);
        String token = HaloUtils.simpleUUID();
        this.cacheStore.putAny(token, (Object)token, 10L, TimeUnit.MINUTES);
        StringBuilder previewUrl = new StringBuilder();
        if (!this.optionService.isEnabledAbsolutePath().booleanValue()) {
            previewUrl.append(this.optionService.getBlogBaseUrl());
        }
        previewUrl.append(sheetMinimalDTO.getFullPath()).append("?token=").append(token);
        return previewUrl.toString();
    }
}

