/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.model.params.StaticContentParam;
import run.halo.app.model.support.StaticFile;
import run.halo.app.service.StaticStorageService;

@RestController
@RequestMapping(value={"/api/admin/statics"})
public class StaticStorageController {
    private final StaticStorageService staticStorageService;

    public StaticStorageController(StaticStorageService staticStorageService) {
        this.staticStorageService = staticStorageService;
    }

    @GetMapping
    @ApiOperation(value="Lists static files")
    public List<StaticFile> list() {
        return this.staticStorageService.listStaticFolder();
    }

    @DeleteMapping
    @ApiOperation(value="Deletes file by relative path")
    public void deletePermanently(@RequestParam(value="path") String path) {
        this.staticStorageService.delete(path);
    }

    @PostMapping
    @ApiOperation(value="Creates a folder")
    public void createFolder(String basePath, @RequestParam(value="folderName") String folderName) {
        this.staticStorageService.createFolder(basePath, folderName);
    }

    @PostMapping(value={"upload"})
    @ApiOperation(value="Uploads static file")
    public void upload(String basePath, @RequestPart(value="file") MultipartFile file) {
        this.staticStorageService.upload(basePath, file);
    }

    @PostMapping(value={"rename"})
    @ApiOperation(value="Renames static file")
    public void rename(String basePath, String newName) {
        this.staticStorageService.rename(basePath, newName);
    }

    @PutMapping(value={"files"})
    @ApiOperation(value="Save static file")
    public void save(@RequestBody StaticContentParam param) {
        this.staticStorageService.save(param.getPath(), param.getContent());
    }
}

