/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.TagDTO;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.params.TagParam;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;

@RestController
@RequestMapping(value={"/api/admin/tags"})
public class TagController {
    private static final Logger log = LoggerFactory.getLogger(TagController.class);
    private final TagService tagService;
    private final PostTagService postTagService;

    public TagController(TagService tagService, PostTagService postTagService) {
        this.tagService = tagService;
        this.postTagService = postTagService;
    }

    @GetMapping
    @ApiOperation(value="Lists tags")
    public List<? extends TagDTO> listTags(@SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort, @ApiParam(value="Return more information(post count) if it is set") @RequestParam(name="more", required=false, defaultValue="false") Boolean more) {
        if (more.booleanValue()) {
            return this.postTagService.listTagWithCountDtos(sort);
        }
        return this.tagService.convertTo(this.tagService.listAll(sort));
    }

    @PostMapping
    @ApiOperation(value="Creates a tag")
    public TagDTO createTag(@Valid @RequestBody TagParam tagParam) {
        Tag tag = tagParam.convertTo();
        log.debug("Tag to be created: [{}]", (Object)tag);
        return this.tagService.convertTo((Tag)this.tagService.create((Object)tag));
    }

    @GetMapping(value={"{tagId:\\d+}"})
    @ApiOperation(value="Gets tag detail by id")
    public TagDTO getBy(@PathVariable(value="tagId") Integer tagId) {
        return this.tagService.convertTo((Tag)this.tagService.getById((Object)tagId));
    }

    @PutMapping(value={"{tagId:\\d+}"})
    @ApiOperation(value="Updates a tag")
    public TagDTO updateBy(@PathVariable(value="tagId") Integer tagId, @Valid @RequestBody TagParam tagParam) {
        Tag tag = (Tag)this.tagService.getById((Object)tagId);
        tagParam.update(tag);
        return this.tagService.convertTo((Tag)this.tagService.update((Object)tag));
    }

    @DeleteMapping(value={"{tagId:\\d+}"})
    @ApiOperation(value="Deletes a tag")
    public TagDTO deletePermanently(@PathVariable(value="tagId") Integer tagId) {
        Tag deletedTag = (Tag)this.tagService.removeById((Object)tagId);
        this.postTagService.removeByTagId(tagId);
        return this.tagService.convertTo(deletedTag);
    }
}

