/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.annotation.DisableOnCondition;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.handler.theme.config.support.Group;
import run.halo.app.handler.theme.config.support.Item;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.model.params.ThemeContentParam;
import run.halo.app.model.support.BaseResponse;
import run.halo.app.model.support.ThemeFile;
import run.halo.app.service.ThemeService;
import run.halo.app.service.ThemeSettingService;
import run.halo.app.utils.ServiceUtils;

@RestController
@RequestMapping(value={"/api/admin/themes"})
public class ThemeController {
    private final ThemeService themeService;
    private final ThemeSettingService themeSettingService;

    public ThemeController(ThemeService themeService, ThemeSettingService themeSettingService) {
        this.themeService = themeService;
        this.themeSettingService = themeSettingService;
    }

    @GetMapping(value={"{themeId:.+}"})
    @ApiOperation(value="Gets theme property by theme id")
    public ThemeProperty getBy(@PathVariable(value="themeId") String themeId) {
        return this.themeService.getThemeOfNonNullBy(themeId);
    }

    @GetMapping
    @ApiOperation(value="Lists all themes")
    public List<ThemeProperty> listAll() {
        return this.themeService.getThemes();
    }

    @GetMapping(value={"activation/files"})
    @ApiOperation(value="Lists all activate theme files")
    public List<ThemeFile> listFiles() {
        return this.themeService.listThemeFolderBy(this.themeService.getActivatedThemeId());
    }

    @GetMapping(value={"{themeId:.+}/files"})
    @ApiOperation(value="Lists theme files by theme id")
    public List<ThemeFile> listFiles(@PathVariable(value="themeId") String themeId) {
        return this.themeService.listThemeFolderBy(themeId);
    }

    @GetMapping(value={"files/content"})
    @ApiOperation(value="Gets template content")
    public BaseResponse<String> getContentBy(@RequestParam(name="path") String path) {
        return BaseResponse.ok((String)HttpStatus.OK.getReasonPhrase(), (Object)this.themeService.getTemplateContent(path));
    }

    @GetMapping(value={"{themeId:.+}/files/content"})
    @ApiOperation(value="Gets template content by theme id")
    public BaseResponse<String> getContentBy(@PathVariable(value="themeId") String themeId, @RequestParam(name="path") String path) {
        return BaseResponse.ok((String)HttpStatus.OK.getReasonPhrase(), (Object)this.themeService.getTemplateContent(themeId, path));
    }

    @PutMapping(value={"files/content"})
    @ApiOperation(value="Updates template content")
    @DisableOnCondition
    public void updateContentBy(@RequestBody ThemeContentParam param) {
        this.themeService.saveTemplateContent(param.getPath(), param.getContent());
    }

    @PutMapping(value={"{themeId:.+}/files/content"})
    @ApiOperation(value="Updates template content by theme id")
    @DisableOnCondition
    public void updateContentBy(@PathVariable(value="themeId") String themeId, @RequestBody ThemeContentParam param) {
        this.themeService.saveTemplateContent(themeId, param.getPath(), param.getContent());
    }

    @GetMapping(value={"activation/template/custom/sheet"})
    @ApiOperation(value="Gets custom sheet templates")
    public List<String> customSheetTemplate() {
        return this.themeService.listCustomTemplates(this.themeService.getActivatedThemeId(), "sheet_");
    }

    @GetMapping(value={"activation/template/custom/post"})
    @ApiOperation(value="Gets custom post templates")
    public List<String> customPostTemplate() {
        return this.themeService.listCustomTemplates(this.themeService.getActivatedThemeId(), "post_");
    }

    @PostMapping(value={"{themeId:.+}/activation"})
    @ApiOperation(value="Activates a theme")
    public ThemeProperty active(@PathVariable(value="themeId") String themeId) {
        return this.themeService.activateTheme(themeId);
    }

    @GetMapping(value={"activation"})
    @ApiOperation(value="Gets activate theme")
    public ThemeProperty getActivateTheme() {
        return this.themeService.getThemeOfNonNullBy(this.themeService.getActivatedThemeId());
    }

    @GetMapping(value={"activation/configurations"})
    @ApiOperation(value="Fetches activated theme configuration")
    public BaseResponse<Object> fetchConfig() {
        return BaseResponse.ok((Object)this.themeService.fetchConfig(this.themeService.getActivatedThemeId()));
    }

    @GetMapping(value={"{themeId:.+}/configurations"})
    @ApiOperation(value="Fetches theme configuration by theme id")
    public List<Group> fetchConfig(@PathVariable(value="themeId") String themeId) {
        return this.themeService.fetchConfig(themeId);
    }

    @GetMapping(value={"{themeId:.+}/configurations/groups/{group}"})
    @ApiOperation(value="Fetches theme configuration by theme id and group name")
    public Set<Item> fetchConfigByGroup(@PathVariable(value="themeId") String themeId, @PathVariable String group) {
        return this.themeService.fetchConfigItemsBy(themeId, group);
    }

    @GetMapping(value={"{themeId:.+}/configurations/groups"})
    @ApiOperation(value="Fetches theme configuration group names by theme id")
    public Set<String> fetchConfigGroups(@PathVariable(value="themeId") String themeId) {
        return ServiceUtils.fetchProperty((Collection)this.themeService.fetchConfig(themeId), Group::getName);
    }

    @GetMapping(value={"activation/settings"})
    @ApiOperation(value="Lists activated theme settings")
    public Map<String, Object> listSettingsBy() {
        return this.themeSettingService.listAsMapBy(this.themeService.getActivatedThemeId());
    }

    @GetMapping(value={"{themeId:.+}/settings"})
    @ApiOperation(value="Lists theme settings by theme id")
    public Map<String, Object> listSettingsBy(@PathVariable(value="themeId") String themeId) {
        return this.themeSettingService.listAsMapBy(themeId);
    }

    @GetMapping(value={"{themeId:.+}/groups/{group}/settings"})
    @ApiOperation(value="Lists theme settings by theme id and group name")
    public Map<String, Object> listSettingsBy(@PathVariable(value="themeId") String themeId, @PathVariable String group) {
        return this.themeSettingService.listAsMapBy(themeId, group);
    }

    @PostMapping(value={"activation/settings"})
    @ApiOperation(value="Saves theme settings")
    public void saveSettingsBy(@RequestBody Map<String, Object> settings) {
        this.themeSettingService.save(settings, this.themeService.getActivatedThemeId());
    }

    @PostMapping(value={"{themeId:.+}/settings"})
    @ApiOperation(value="Saves theme settings")
    @CacheLock(prefix="save_theme_setting_by_themeId")
    public void saveSettingsBy(@PathVariable(value="themeId") String themeId, @RequestBody Map<String, Object> settings) {
        this.themeSettingService.save(settings, themeId);
    }

    @DeleteMapping(value={"{themeId:.+}"})
    @ApiOperation(value="Deletes a theme")
    @DisableOnCondition
    public void deleteBy(@PathVariable(value="themeId") String themeId, @RequestParam(value="deleteSettings", defaultValue="false") Boolean deleteSettings) {
        this.themeService.deleteTheme(themeId, deleteSettings);
    }

    @PostMapping(value={"upload"})
    @ApiOperation(value="Uploads a theme")
    public ThemeProperty uploadTheme(@RequestPart(value="file") MultipartFile file) {
        return this.themeService.upload(file);
    }

    @PutMapping(value={"upload/{themeId:.+}"})
    @ApiOperation(value="Upgrades theme by file")
    public ThemeProperty updateThemeByUpload(@PathVariable(value="themeId") String themeId, @RequestPart(value="file") MultipartFile file) {
        return this.themeService.update(themeId, file);
    }

    @PostMapping(value={"fetching"})
    @ApiOperation(value="Fetches a new theme")
    public ThemeProperty fetchTheme(@RequestParam(value="uri") String uri) {
        return this.themeService.fetch(uri);
    }

    @PutMapping(value={"fetching/{themeId:.+}"})
    @ApiOperation(value="Upgrades theme from remote")
    public ThemeProperty updateThemeByFetching(@PathVariable(value="themeId") String themeId) {
        return this.themeService.update(themeId);
    }

    @PostMapping(value={"reload"})
    @ApiOperation(value="Reloads themes")
    public void reload() {
        this.themeService.reload();
    }

    @GetMapping(value={"activation/template/exists"})
    @ApiOperation(value="Determines if template exists")
    public BaseResponse<Boolean> exists(@RequestParam(value="template") String template) {
        return BaseResponse.ok((Object)this.themeService.templateExists(template));
    }
}

