/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.admin.api;

import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.annotation.DisableOnCondition;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.exception.BadRequestException;
import run.halo.app.model.dto.UserDTO;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.MFAType;
import run.halo.app.model.params.MultiFactorAuthParam;
import run.halo.app.model.params.PasswordParam;
import run.halo.app.model.params.UserParam;
import run.halo.app.model.support.BaseResponse;
import run.halo.app.model.support.UpdateCheck;
import run.halo.app.model.vo.MultiFactorAuthVO;
import run.halo.app.service.UserService;
import run.halo.app.utils.HaloUtils;
import run.halo.app.utils.TwoFactorAuthUtils;
import run.halo.app.utils.ValidationUtils;

@RestController
@RequestMapping(value={"/api/admin/users"})
public class UserController {
    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping(value={"profiles"})
    @ApiOperation(value="Gets user profile")
    public UserDTO getProfile(User user) {
        return (UserDTO)new UserDTO().convertFrom((Object)user);
    }

    @PutMapping(value={"profiles"})
    @ApiOperation(value="Updates user profile")
    @DisableOnCondition
    public UserDTO updateProfile(@RequestBody UserParam userParam, User user) {
        ValidationUtils.validate((Object)userParam, (Class[])new Class[]{UpdateCheck.class});
        userParam.update((Object)user);
        return (UserDTO)new UserDTO().convertFrom((Object)((User)this.userService.update((Object)user)));
    }

    @PutMapping(value={"profiles/password"})
    @ApiOperation(value="Updates user's password")
    @DisableOnCondition
    public BaseResponse<String> updatePassword(@RequestBody @Valid PasswordParam passwordParam, User user) {
        this.userService.updatePassword(passwordParam.getOldPassword(), passwordParam.getNewPassword(), user.getId());
        return BaseResponse.ok((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f");
    }

    @PutMapping(value={"mfa/generate"})
    @ApiOperation(value="Generate Multi-Factor Auth qr image")
    @DisableOnCondition
    public MultiFactorAuthVO generateMFAQrImage(@RequestBody MultiFactorAuthParam multiFactorAuthParam, User user) {
        if (MFAType.NONE == user.getMfaType()) {
            if (MFAType.TFA_TOTP == multiFactorAuthParam.getMfaType()) {
                String mfaKey = TwoFactorAuthUtils.generateTFAKey();
                String optAuthUrl = TwoFactorAuthUtils.generateOtpAuthUrl((String)user.getNickname(), (String)mfaKey);
                String qrImageBase64 = "data:image/png;base64," + Base64Utils.encodeToString((byte[])HaloUtils.generateQrCodeToPng((String)optAuthUrl, (int)128, (int)128));
                return new MultiFactorAuthVO(qrImageBase64, optAuthUrl, mfaKey, MFAType.TFA_TOTP);
            }
            throw new BadRequestException("\u6682\u4e0d\u652f\u6301\u7684 MFA \u8ba4\u8bc1\u7684\u65b9\u5f0f");
        }
        throw new BadRequestException("MFA \u8ba4\u8bc1\u5df2\u542f\u7528\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
    }

    @PutMapping(value={"mfa/update"})
    @ApiOperation(value="Updates user's Multi Factor Auth")
    @CacheLock(autoDelete=false, prefix="mfa")
    @DisableOnCondition
    public MultiFactorAuthVO updateMFAuth(@RequestBody @Valid MultiFactorAuthParam multiFactorAuthParam, User user) {
        if (StringUtils.isNotBlank((CharSequence)user.getMfaKey()) && MFAType.useMFA((MFAType)multiFactorAuthParam.getMfaType())) {
            return new MultiFactorAuthVO(MFAType.TFA_TOTP);
        }
        if (StringUtils.isBlank((CharSequence)user.getMfaKey()) && !MFAType.useMFA((MFAType)multiFactorAuthParam.getMfaType())) {
            return new MultiFactorAuthVO(MFAType.NONE);
        }
        String mfaKey = StringUtils.isNotBlank((CharSequence)user.getMfaKey()) ? user.getMfaKey() : multiFactorAuthParam.getMfaKey();
        TwoFactorAuthUtils.validateTFACode((String)mfaKey, (String)multiFactorAuthParam.getAuthcode());
        User updateUser = this.userService.updateMFA(multiFactorAuthParam.getMfaType(), multiFactorAuthParam.getMfaKey(), user.getId());
        return new MultiFactorAuthVO(updateUser.getMfaType());
    }
}

