/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.controller.content.auth.ContentAuthenticationManager;
import run.halo.app.controller.content.auth.ContentAuthenticationRequest;
import run.halo.app.controller.content.model.CategoryModel;
import run.halo.app.controller.content.model.JournalModel;
import run.halo.app.controller.content.model.LinkModel;
import run.halo.app.controller.content.model.PhotoModel;
import run.halo.app.controller.content.model.PostModel;
import run.halo.app.controller.content.model.SheetModel;
import run.halo.app.controller.content.model.TagModel;
import run.halo.app.exception.AuthenticationException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.UnsupportedException;
import run.halo.app.model.dto.CategoryDTO;
import run.halo.app.model.dto.post.BasePostMinimalDTO;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.enums.EncryptTypeEnum;
import run.halo.app.model.enums.PostPermalinkType;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.enums.SheetPermalinkType;
import run.halo.app.service.CategoryService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostService;
import run.halo.app.service.SheetService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.assembler.PostRenderAssembler;

@Controller
@RequestMapping
public class ContentContentController {
    private static final Logger log = LoggerFactory.getLogger(ContentContentController.class);
    private final PostModel postModel;
    private final SheetModel sheetModel;
    private final CategoryModel categoryModel;
    private final TagModel tagModel;
    private final JournalModel journalModel;
    private final PhotoModel photoModel;
    private final LinkModel linkModel;
    private final OptionService optionService;
    private final PostService postService;
    private final SheetService sheetService;
    private final CategoryService categoryService;
    private final ThemeService themeService;
    private final PostRenderAssembler postRenderAssembler;
    private final ContentAuthenticationManager providerManager;

    public ContentContentController(PostModel postModel, SheetModel sheetModel, CategoryModel categoryModel, TagModel tagModel, JournalModel journalModel, PhotoModel photoModel, LinkModel linkModel, OptionService optionService, PostService postService, SheetService sheetService, CategoryService categoryService, ThemeService themeService, PostRenderAssembler postRenderAssembler, ContentAuthenticationManager providerManager) {
        this.postModel = postModel;
        this.sheetModel = sheetModel;
        this.categoryModel = categoryModel;
        this.tagModel = tagModel;
        this.journalModel = journalModel;
        this.photoModel = photoModel;
        this.linkModel = linkModel;
        this.optionService = optionService;
        this.postService = postService;
        this.sheetService = sheetService;
        this.categoryService = categoryService;
        this.themeService = themeService;
        this.postRenderAssembler = postRenderAssembler;
        this.providerManager = providerManager;
    }

    @GetMapping(value={"{prefix}"})
    public String content(@PathVariable(value="prefix") String prefix, @RequestParam(value="token", required=false) String token, Model model) {
        if (this.optionService.getArchivesPrefix().equals(prefix)) {
            return this.postModel.archives(Integer.valueOf(1), model);
        }
        if (this.optionService.getCategoriesPrefix().equals(prefix)) {
            return this.categoryModel.list(model);
        }
        if (this.optionService.getTagsPrefix().equals(prefix)) {
            return this.tagModel.list(model);
        }
        if (this.optionService.getJournalsPrefix().equals(prefix)) {
            return this.journalModel.list(Integer.valueOf(1), model);
        }
        if (this.optionService.getPhotosPrefix().equals(prefix)) {
            return this.photoModel.list(Integer.valueOf(1), model);
        }
        if (this.optionService.getLinksPrefix().equals(prefix)) {
            return this.linkModel.list(model);
        }
        if (this.optionService.getSheetPermalinkType().equals((Object)SheetPermalinkType.ROOT)) {
            Sheet sheet = (Sheet)this.sheetService.getBySlug(prefix);
            return this.sheetModel.content(sheet, token, model);
        }
        throw this.buildPathNotFoundException();
    }

    @GetMapping(value={"{prefix}/page/{page:\\d+}"})
    public String content(@PathVariable(value="prefix") String prefix, @PathVariable(value="page") Integer page, HttpServletRequest request, Model model) {
        if (this.optionService.getArchivesPrefix().equals(prefix)) {
            return this.postModel.archives(page, model);
        }
        if (this.optionService.getJournalsPrefix().equals(prefix)) {
            return this.journalModel.list(page, model);
        }
        if (this.optionService.getPhotosPrefix().equals(prefix)) {
            return this.photoModel.list(page, model);
        }
        throw this.buildPathNotFoundException();
    }

    @GetMapping(value={"{prefix}/{slug}"})
    public String content(@PathVariable(value="prefix") String prefix, @PathVariable(value="slug") String slug, @RequestParam(value="token", required=false) String token, Model model) {
        PostPermalinkType postPermalinkType = this.optionService.getPostPermalinkType();
        if (this.optionService.getArchivesPrefix().equals(prefix)) {
            if (postPermalinkType.equals((Object)PostPermalinkType.DEFAULT)) {
                Post post = (Post)this.postService.getBySlug(slug);
                return this.postModel.content(post, token, model);
            }
            if (postPermalinkType.equals((Object)PostPermalinkType.ID_SLUG) && StringUtils.isNumeric((CharSequence)slug)) {
                Post post = (Post)this.postService.getById((Object)Integer.parseInt(slug));
                return this.postModel.content(post, token, model);
            }
        }
        if (this.optionService.getCategoriesPrefix().equals(prefix)) {
            return this.categoryModel.listPost(model, slug, Integer.valueOf(1));
        }
        if (this.optionService.getTagsPrefix().equals(prefix)) {
            return this.tagModel.listPost(model, slug, Integer.valueOf(1));
        }
        if (postPermalinkType.equals((Object)PostPermalinkType.YEAR) && prefix.length() == 4 && StringUtils.isNumeric((CharSequence)prefix)) {
            Post post = this.postService.getBy(Integer.valueOf(Integer.parseInt(prefix)), slug);
            return this.postModel.content(post, token, model);
        }
        if (this.optionService.getSheetPermalinkType().equals((Object)SheetPermalinkType.SECONDARY) && this.optionService.getSheetPrefix().equals(prefix)) {
            Sheet sheet = (Sheet)this.sheetService.getBySlug(slug);
            return this.sheetModel.content(sheet, token, model);
        }
        throw this.buildPathNotFoundException();
    }

    @GetMapping(value={"{prefix}/{slug}/page/{page:\\d+}"})
    public String content(@PathVariable(value="prefix") String prefix, @PathVariable(value="slug") String slug, @PathVariable(value="page") Integer page, Model model) {
        if (this.optionService.getCategoriesPrefix().equals(prefix)) {
            return this.categoryModel.listPost(model, slug, page);
        }
        if (this.optionService.getTagsPrefix().equals(prefix)) {
            return this.tagModel.listPost(model, slug, page);
        }
        throw this.buildPathNotFoundException();
    }

    @GetMapping(value={"{year:\\d+}/{month:\\d+}/{slug}"})
    public String content(@PathVariable(value="year") Integer year, @PathVariable(value="month") Integer month, @PathVariable(value="slug") String slug, @RequestParam(value="token", required=false) String token, Model model) {
        PostPermalinkType postPermalinkType = this.optionService.getPostPermalinkType();
        if (postPermalinkType.equals((Object)PostPermalinkType.DATE)) {
            Post post = this.postService.getBy(year, month, slug);
            return this.postModel.content(post, token, model);
        }
        throw this.buildPathNotFoundException();
    }

    @GetMapping(value={"{year:\\d+}/{month:\\d+}/{day:\\d+}/{slug}"})
    public String content(@PathVariable(value="year") Integer year, @PathVariable(value="month") Integer month, @PathVariable(value="day") Integer day, @PathVariable(value="slug") String slug, @RequestParam(value="token", required=false) String token, Model model) {
        PostPermalinkType postPermalinkType = this.optionService.getPostPermalinkType();
        if (postPermalinkType.equals((Object)PostPermalinkType.DAY)) {
            Post post = this.postService.getBy(year, month, day, slug);
            return this.postModel.content(post, token, model);
        }
        throw this.buildPathNotFoundException();
    }

    @PostMapping(value={"content/{type}/{slug:.*}/authentication"})
    @CacheLock(traceRequest=true, expired=2L)
    public String password(@PathVariable(value="type") String type, @PathVariable(value="slug") String slug, @RequestParam(value="password") String password, HttpServletRequest request) throws UnsupportedEncodingException {
        if (EncryptTypeEnum.POST.getName().equals(type)) {
            return this.authenticatePost(slug, type, password, request);
        }
        if (EncryptTypeEnum.CATEGORY.getName().equals(type)) {
            return this.authenticateCategory(slug, type, password, request);
        }
        throw new UnsupportedException("\u672a\u77e5\u7684\u52a0\u5bc6\u7c7b\u578b");
    }

    private String authenticatePost(String slug, String type, String password, HttpServletRequest request) {
        ContentAuthenticationRequest authRequest = new ContentAuthenticationRequest();
        authRequest.setPassword(password);
        Post post = this.postService.getBy(PostStatus.INTIMATE, slug);
        post.setSlug(URLEncoder.encode(post.getSlug(), StandardCharsets.UTF_8));
        authRequest.setId(post.getId());
        authRequest.setPrincipal(EncryptTypeEnum.POST.getName());
        try {
            this.providerManager.authenticate(authRequest);
            BasePostMinimalDTO basePostMinimal = this.postRenderAssembler.convertToMinimal(post);
            return "redirect:" + this.buildRedirectUrl(basePostMinimal.getFullPath());
        }
        catch (AuthenticationException e) {
            request.setAttribute("errorMsg", (Object)e.getMessage());
            request.setAttribute("type", (Object)type);
            request.setAttribute("slug", (Object)slug);
            return this.getPasswordPageUriToForward();
        }
    }

    private String authenticateCategory(String slug, String type, String password, HttpServletRequest request) {
        ContentAuthenticationRequest authRequest = new ContentAuthenticationRequest();
        authRequest.setPassword(password);
        Category category = this.categoryService.getBySlugOfNonNull(slug);
        category.setSlug(URLEncoder.encode(category.getSlug(), StandardCharsets.UTF_8));
        authRequest.setId(category.getId());
        authRequest.setPrincipal(EncryptTypeEnum.CATEGORY.getName());
        try {
            this.providerManager.authenticate(authRequest);
            CategoryDTO categoryDto = this.categoryService.convertTo(category);
            return "redirect:" + this.buildRedirectUrl(categoryDto.getFullPath());
        }
        catch (AuthenticationException e) {
            request.setAttribute("errorMsg", (Object)e.getMessage());
            request.setAttribute("type", (Object)type);
            request.setAttribute("slug", (Object)slug);
            return this.getPasswordPageUriToForward();
        }
    }

    private String getPasswordPageUriToForward() {
        if (this.themeService.templateExists("post_password.ftl")) {
            return this.themeService.render("post_password");
        }
        return "common/template/post_password";
    }

    private NotFoundException buildPathNotFoundException() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        String requestUri = "";
        if (requestAttributes instanceof ServletRequestAttributes) {
            requestUri = ((ServletRequestAttributes)requestAttributes).getRequest().getRequestURI();
        }
        return new NotFoundException("\u65e0\u6cd5\u5b9a\u4f4d\u5230\u8be5\u8def\u5f84\uff1a" + requestUri);
    }

    private String buildRedirectUrl(String fullPath) {
        StringBuilder redirectUrl = new StringBuilder();
        if (!this.optionService.isEnabledAbsolutePath().booleanValue()) {
            redirectUrl.append(this.optionService.getBlogBaseUrl());
        }
        redirectUrl.append(fullPath);
        return redirectUrl.toString();
    }
}

