/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.OptionalLong;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RegExUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import run.halo.app.model.dto.CategoryDTO;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Post;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.vo.PostDetailVO;
import run.halo.app.service.CategoryService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostService;
import run.halo.app.service.assembler.PostRenderAssembler;

@Controller
public class ContentFeedController {
    private static final Logger log = LoggerFactory.getLogger(ContentFeedController.class);
    private static final String UTF_8_SUFFIX = ";charset=UTF-8";
    private static final String XML_INVALID_CHAR = "[\\x00-\\x1F\\x7F]";
    private static final String XML_MEDIA_TYPE = "application/xml;charset=UTF-8";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private final PostService postService;
    private final PostRenderAssembler postRenderAssembler;
    private final CategoryService categoryService;
    private final PostCategoryService postCategoryService;
    private final OptionService optionService;
    private final FreeMarkerConfigurer freeMarker;

    public ContentFeedController(PostService postService, PostRenderAssembler postRenderAssembler, CategoryService categoryService, PostCategoryService postCategoryService, OptionService optionService, FreeMarkerConfigurer freeMarker) {
        this.postService = postService;
        this.postRenderAssembler = postRenderAssembler;
        this.categoryService = categoryService;
        this.postCategoryService = postCategoryService;
        this.optionService = optionService;
        this.freeMarker = freeMarker;
    }

    @GetMapping(value={"feed", "feed.xml", "rss", "rss.xml"}, produces={"application/xml;charset=UTF-8"})
    @ResponseBody
    public String feed(Model model, HttpServletResponse response) throws IOException, TemplateException {
        List posts = this.buildPosts(this.buildPostPageable(this.optionService.getRssPageSize()));
        model.addAttribute("posts", (Object)posts);
        Timestamp lastModified = this.getLastModifiedTime(posts);
        this.lastModified2ResponseHeader(response, lastModified);
        model.addAttribute("lastModified", (Object)lastModified);
        Template template = this.freeMarker.getConfiguration().getTemplate("common/web/rss.ftl");
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model);
    }

    @GetMapping(value={"feed/categories/{slug}", "feed/categories/{slug}.xml"}, produces={"application/xml;charset=UTF-8"})
    @ResponseBody
    public String feed(Model model, @PathVariable(name="slug") String slug, HttpServletResponse response) throws IOException, TemplateException {
        Category category = this.categoryService.getBySlugOfNonNull(slug);
        CategoryDTO categoryDTO = this.categoryService.convertTo(category);
        List posts = this.buildCategoryPosts(this.buildPostPageable(this.optionService.getRssPageSize()), categoryDTO);
        model.addAttribute("category", (Object)categoryDTO);
        model.addAttribute("posts", (Object)posts);
        Timestamp lastModified = this.getLastModifiedTime(posts);
        this.lastModified2ResponseHeader(response, lastModified);
        model.addAttribute("lastModified", (Object)lastModified);
        Template template = this.freeMarker.getConfiguration().getTemplate("common/web/rss.ftl");
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model);
    }

    @GetMapping(value={"atom", "atom.xml"}, produces={"application/xml;charset=UTF-8"})
    @ResponseBody
    public String atom(Model model, HttpServletResponse response) throws IOException, TemplateException {
        List posts = this.buildPosts(this.buildPostPageable(this.optionService.getRssPageSize()));
        model.addAttribute("posts", (Object)posts);
        Timestamp lastModified = this.getLastModifiedTime(posts);
        this.lastModified2ResponseHeader(response, lastModified);
        model.addAttribute("lastModified", (Object)lastModified);
        Template template = this.freeMarker.getConfiguration().getTemplate("common/web/atom.ftl");
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model);
    }

    @GetMapping(value={"atom/categories/{slug}", "atom/categories/{slug}.xml"}, produces={"application/xml;charset=UTF-8"})
    @ResponseBody
    public String atom(Model model, @PathVariable(name="slug") String slug, HttpServletResponse response) throws IOException, TemplateException {
        Category category = this.categoryService.getBySlugOfNonNull(slug);
        CategoryDTO categoryDTO = this.categoryService.convertTo(category);
        List posts = this.buildCategoryPosts(this.buildPostPageable(this.optionService.getRssPageSize()), categoryDTO);
        model.addAttribute("category", (Object)categoryDTO);
        model.addAttribute("posts", (Object)posts);
        Timestamp lastModified = this.getLastModifiedTime(posts);
        this.lastModified2ResponseHeader(response, lastModified);
        model.addAttribute("lastModified", (Object)lastModified);
        Template template = this.freeMarker.getConfiguration().getTemplate("common/web/atom.ftl");
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model);
    }

    @GetMapping(value={"sitemap", "sitemap.xml"}, produces={"application/xml;charset=UTF-8"})
    @ResponseBody
    public String sitemapXml(Model model, @PageableDefault(size=0x7FFFFFFF, sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) throws IOException, TemplateException {
        model.addAttribute("posts", (Object)this.buildPosts(pageable));
        Template template = this.freeMarker.getConfiguration().getTemplate("common/web/sitemap_xml.ftl");
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model);
    }

    @GetMapping(value={"sitemap.html"})
    public String sitemapHtml(Model model, @PageableDefault(size=0x7FFFFFFF, sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        model.addAttribute("posts", (Object)this.buildPosts(pageable));
        return "common/web/sitemap_html";
    }

    @GetMapping(value={"robots.txt"}, produces={"text/plain"})
    @ResponseBody
    public String robots(Model model) throws IOException, TemplateException {
        Template template = this.freeMarker.getConfiguration().getTemplate("common/web/robots.ftl");
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model);
    }

    @NonNull
    private Pageable buildPostPageable(int size) {
        return PageRequest.of((int)0, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
    }

    private List<PostDetailVO> buildPosts(@NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        Page postPage = this.postService.pageBy(PostStatus.PUBLISHED, pageable);
        Page posts = this.convertToDetailPageVo(postPage);
        return posts.getContent();
    }

    @NonNull
    private Page<PostDetailVO> convertToDetailPageVo(Page<Post> postPage) {
        Assert.notNull(postPage, (String)"The postPage must not be null.");
        Page posts = this.postRenderAssembler.convertToDetailVo(postPage);
        posts.getContent().forEach(postDetailVO -> {
            postDetailVO.setContent(RegExUtils.replaceAll((String)postDetailVO.getContent(), (String)XML_INVALID_CHAR, (String)""));
            postDetailVO.setSummary(RegExUtils.replaceAll((String)postDetailVO.getSummary(), (String)XML_INVALID_CHAR, (String)""));
        });
        return posts;
    }

    private List<PostDetailVO> buildCategoryPosts(@NonNull Pageable pageable, @NonNull CategoryDTO category) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        Assert.notNull((Object)category, (String)"Category slug must not be null");
        Page postPage = this.postCategoryService.pagePostBy(category.getId(), PostStatus.PUBLISHED, pageable);
        Page posts = this.convertToDetailPageVo(postPage);
        return posts.getContent();
    }

    private Timestamp getLastModifiedTime(List<PostDetailVO> posts) {
        OptionalLong lastModifiedTimestamp = posts.stream().mapToLong(post -> post.getEditTime().getTime()).max();
        if (lastModifiedTimestamp.isEmpty()) {
            return new Timestamp(System.currentTimeMillis());
        }
        return new Timestamp(lastModifiedTimestamp.getAsLong());
    }

    private void lastModified2ResponseHeader(HttpServletResponse response, Timestamp time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
        response.setHeader(LAST_MODIFIED_HEADER, dateFormat.format(time));
    }
}

