/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import run.halo.app.controller.content.model.PostModel;
import run.halo.app.model.entity.Post;
import run.halo.app.model.enums.PostPermalinkType;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostService;

@Controller
@RequestMapping
public class ContentIndexController {
    private static final Logger log = LoggerFactory.getLogger(ContentIndexController.class);
    private final PostService postService;
    private final OptionService optionService;
    private final PostModel postModel;

    public ContentIndexController(PostService postService, OptionService optionService, PostModel postModel) {
        this.postService = postService;
        this.optionService = optionService;
        this.postModel = postModel;
    }

    @GetMapping
    public String index(Integer p, String token, Model model) {
        PostPermalinkType permalinkType = this.optionService.getPostPermalinkType();
        if (PostPermalinkType.ID.equals((Object)permalinkType) && !Objects.isNull(p)) {
            Post post = (Post)this.postService.getById((Object)p);
            return this.postModel.content(post, token, model);
        }
        return this.index(model, Integer.valueOf(1));
    }

    @GetMapping(value={"page/{page}"})
    public String index(Model model, @PathVariable(value="page") Integer page) {
        return this.postModel.list(page, model);
    }
}

