/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.HtmlUtils;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.assembler.PostRenderAssembler;

@Controller
@RequestMapping(value={"/search"})
public class ContentSearchController {
    private final PostService postService;
    private final PostRenderAssembler postRenderAssembler;
    private final OptionService optionService;
    private final ThemeService themeService;

    public ContentSearchController(PostService postService, PostRenderAssembler postRenderAssembler, OptionService optionService, ThemeService themeService) {
        this.postService = postService;
        this.postRenderAssembler = postRenderAssembler;
        this.optionService = optionService;
        this.themeService = themeService;
    }

    @GetMapping
    public String search(Model model, @RequestParam(value="keyword") String keyword) {
        return this.search(model, HtmlUtils.htmlEscape((String)keyword), Integer.valueOf(1), Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
    }

    @GetMapping(value={"page/{page}"})
    public String search(Model model, @RequestParam(value="keyword") String keyword, @PathVariable(value="page") Integer page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)this.optionService.getPostPageSize(), (Sort)sort);
        Page postPage = this.postService.pageBy(keyword, (Pageable)pageable);
        Page posts = this.postRenderAssembler.convertToListVo(postPage);
        model.addAttribute("is_search", (Object)true);
        model.addAttribute("keyword", (Object)HtmlUtils.htmlEscape((String)keyword));
        model.addAttribute("posts", (Object)posts);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("search");
    }
}

