/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.exception.ServiceException;
import run.halo.app.model.entity.User;
import run.halo.app.model.properties.BlogProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.support.HaloConst;
import run.halo.app.service.OptionService;
import run.halo.app.service.UserService;
import run.halo.app.utils.HaloUtils;

@Controller
public class MainController {
    private static final String INDEX_REDIRECT_URI = "index.html";
    private static final String INSTALL_REDIRECT_URI = "index.html#install";
    private final UserService userService;
    private final OptionService optionService;
    private final HaloProperties haloProperties;

    public MainController(UserService userService, OptionService optionService, HaloProperties haloProperties) {
        this.userService = userService;
        this.optionService = optionService;
        this.haloProperties = haloProperties;
    }

    @GetMapping(value={"${halo.admin-path:admin}"})
    public void admin(HttpServletResponse response) throws IOException {
        String adminIndexRedirectUri = HaloUtils.ensureBoth((String)this.haloProperties.getAdminPath(), (String)"/") + INDEX_REDIRECT_URI;
        response.sendRedirect(adminIndexRedirectUri);
    }

    @GetMapping(value={"version"})
    @ResponseBody
    public String version() {
        return HaloConst.HALO_VERSION;
    }

    @GetMapping(value={"install"})
    public void installation(HttpServletResponse response) throws IOException {
        String installRedirectUri = StringUtils.appendIfMissing((String)this.haloProperties.getAdminPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + INSTALL_REDIRECT_URI;
        response.sendRedirect(installRedirectUri);
    }

    @GetMapping(value={"avatar"})
    public void avatar(HttpServletResponse response) throws IOException {
        User user = (User)this.userService.getCurrentUser().orElseThrow(() -> new ServiceException("\u672a\u67e5\u8be2\u5230\u535a\u4e3b\u4fe1\u606f"));
        if (StringUtils.isNotEmpty((CharSequence)user.getAvatar())) {
            response.sendRedirect(HaloUtils.normalizeUrl((String)user.getAvatar()));
        }
    }

    @GetMapping(value={"logo"})
    public void logo(HttpServletResponse response) throws IOException {
        String blogLogo = this.optionService.getByProperty((PropertyEnum)BlogProperties.BLOG_LOGO).orElse("").toString();
        if (StringUtils.isNotEmpty((CharSequence)blogLogo)) {
            response.sendRedirect(HaloUtils.normalizeUrl((String)blogLogo));
        }
    }

    @GetMapping(value={"favicon.ico"})
    public void favicon(HttpServletResponse response) throws IOException {
        String favicon = this.optionService.getByProperty((PropertyEnum)BlogProperties.BLOG_FAVICON).orElse("").toString();
        if (StringUtils.isNotEmpty((CharSequence)favicon)) {
            response.sendRedirect(HaloUtils.normalizeUrl((String)favicon));
        }
    }
}

