/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.controller.content.auth.CategoryAuthentication;
import run.halo.app.controller.content.auth.ContentAuthenticationManager;
import run.halo.app.controller.content.auth.ContentAuthenticationRequest;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.model.dto.CategoryDTO;
import run.halo.app.model.entity.Category;
import run.halo.app.model.enums.EncryptTypeEnum;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.vo.PostListVO;
import run.halo.app.service.CategoryService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.assembler.PostRenderAssembler;

@RestController(value="ApiContentCategoryController")
@RequestMapping(value={"/api/content/categories"})
public class CategoryController {
    private final CategoryService categoryService;
    private final PostCategoryService postCategoryService;
    private final PostRenderAssembler postRenderAssembler;
    private final CategoryAuthentication categoryAuthentication;
    private final ContentAuthenticationManager contentAuthenticationManager;

    public CategoryController(CategoryService categoryService, PostCategoryService postCategoryService, PostRenderAssembler postRenderAssembler, CategoryAuthentication categoryAuthentication, ContentAuthenticationManager contentAuthenticationManager) {
        this.categoryService = categoryService;
        this.postCategoryService = postCategoryService;
        this.postRenderAssembler = postRenderAssembler;
        this.categoryAuthentication = categoryAuthentication;
        this.contentAuthenticationManager = contentAuthenticationManager;
    }

    @GetMapping
    @ApiOperation(value="Lists categories")
    public List<? extends CategoryDTO> listCategories(@SortDefault(sort={"updateTime"}, direction=Sort.Direction.DESC) Sort sort, @RequestParam(name="more", required=false, defaultValue="false") Boolean more) {
        if (more.booleanValue()) {
            return this.postCategoryService.listCategoryWithPostCountDto(sort);
        }
        return this.categoryService.convertTo(this.categoryService.listAll(sort));
    }

    @GetMapping(value={"{slug}/posts"})
    @ApiOperation(value="Lists posts by category slug")
    public Page<PostListVO> listPostsBy(@PathVariable(value="slug") String slug, @RequestParam(value="password", required=false) String password, @PageableDefault(sort={"topPriority", "updateTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Category category = this.categoryService.getBySlugOfNonNull(slug);
        ImmutableSet statusesToQuery = Sets.immutableEnumSet((Enum)PostStatus.PUBLISHED, (Enum[])new PostStatus[0]);
        if (this.allowIntimatePosts(category.getId(), password)) {
            statusesToQuery = Sets.immutableEnumSet((Enum)PostStatus.PUBLISHED, (Enum[])new PostStatus[]{PostStatus.INTIMATE});
        }
        Page postPage = this.postCategoryService.pagePostBy(category.getId(), (Set)statusesToQuery, pageable);
        return this.postRenderAssembler.convertToListVo(postPage);
    }

    private boolean allowIntimatePosts(Integer categoryId, String password) {
        Assert.notNull((Object)categoryId, (String)"The categoryId must not be null.");
        if (!this.categoryService.isPrivate(categoryId)) {
            return false;
        }
        if (this.categoryAuthentication.isAuthenticated(categoryId)) {
            return true;
        }
        if (password != null) {
            ContentAuthenticationRequest authRequest = ContentAuthenticationRequest.of((Integer)categoryId, (String)password, (String)EncryptTypeEnum.CATEGORY.getName());
            this.contentAuthenticationManager.authenticate(authRequest);
            return true;
        }
        throw new ForbiddenException("\u60a8\u6ca1\u6709\u8be5\u5206\u7c7b\u7684\u8bbf\u95ee\u6743\u9650");
    }
}

