/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.cache.lock.CacheParam;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.dto.JournalWithCmtCountDTO;
import run.halo.app.model.entity.Journal;
import run.halo.app.model.entity.JournalComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.enums.JournalType;
import run.halo.app.model.params.BaseCommentParam;
import run.halo.app.model.params.JournalCommentParam;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.model.vo.CommentWithHasChildrenVO;
import run.halo.app.service.JournalCommentService;
import run.halo.app.service.JournalService;
import run.halo.app.service.OptionService;
import run.halo.app.service.assembler.comment.JournalCommentRenderAssembler;

@RestController(value="ApiContentJournalController")
@RequestMapping(value={"/api/content/journals"})
public class JournalController {
    private final JournalService journalService;
    private final JournalCommentRenderAssembler journalCommentRenderAssembler;
    private final JournalCommentService journalCommentService;
    private final OptionService optionService;

    public JournalController(JournalService journalService, JournalCommentRenderAssembler journalCommentRenderAssembler, JournalCommentService journalCommentService, OptionService optionService) {
        this.journalService = journalService;
        this.journalCommentRenderAssembler = journalCommentRenderAssembler;
        this.journalCommentService = journalCommentService;
        this.optionService = optionService;
    }

    @GetMapping
    @ApiOperation(value="Lists journals")
    public Page<JournalWithCmtCountDTO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Page journals = this.journalService.pageBy(JournalType.PUBLIC, pageable);
        return this.journalService.convertToCmtCountDto(journals);
    }

    @GetMapping(value={"{journalId:\\d+}"})
    @ApiOperation(value="Gets a journal detail")
    public JournalWithCmtCountDTO getBy(@PathVariable(value="journalId") Integer journalId) {
        Journal journal = (Journal)this.journalService.getById((Object)journalId);
        return this.journalService.convertTo(journal);
    }

    @GetMapping(value={"{journalId:\\d+}/comments/top_view"})
    public Page<CommentWithHasChildrenVO> listTopComments(@PathVariable(value="journalId") Integer journalId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        Page comments = this.journalCommentService.pageTopCommentsBy(journalId, CommentStatus.PUBLISHED, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.forEach(arg_0 -> ((JournalCommentRenderAssembler)this.journalCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @GetMapping(value={"{journalId:\\d+}/comments/{commentParentId:\\d+}/children"})
    public List<BaseCommentDTO> listChildrenBy(@PathVariable(value="journalId") Integer journalId, @PathVariable(value="commentParentId") Long commentParentId, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        List postComments = this.journalCommentService.listChildrenBy(journalId, commentParentId, CommentStatus.PUBLISHED, sort);
        return this.journalCommentRenderAssembler.convertTo(postComments);
    }

    @GetMapping(value={"{journalId:\\d+}/comments/tree_view"})
    @ApiOperation(value="Lists comments with tree view")
    public Page<BaseCommentVO> listCommentsTree(@PathVariable(value="journalId") Integer journalId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        Page comments = this.journalCommentService.pageVosBy(journalId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.getContent().forEach(arg_0 -> ((JournalCommentRenderAssembler)this.journalCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @GetMapping(value={"{journalId:\\d+}/comments/list_view"})
    @ApiOperation(value="Lists comment with list view")
    public Page<BaseCommentWithParentVO> listComments(@PathVariable(value="journalId") Integer journalId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        Page comments = this.journalCommentService.pageWithParentVoBy(journalId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.getContent().forEach(arg_0 -> ((JournalCommentRenderAssembler)this.journalCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @PostMapping(value={"comments"})
    @ApiOperation(value="Comments a post")
    @CacheLock(autoDelete=false, traceRequest=true)
    public BaseCommentDTO comment(@RequestBody JournalCommentParam journalCommentParam) {
        journalCommentParam.setContent(HtmlUtils.htmlEscape((String)journalCommentParam.getContent(), (String)StandardCharsets.UTF_8.displayName()));
        return this.journalCommentRenderAssembler.convertTo((JournalComment)this.journalCommentService.createBy((BaseCommentParam)journalCommentParam));
    }

    @PostMapping(value={"{id:\\d+}/likes"})
    @ApiOperation(value="Likes a journal")
    @CacheLock(autoDelete=false, traceRequest=true)
    public void like(@PathVariable(value="id") @CacheParam Integer id) {
        this.journalService.increaseLike(id);
    }
}

