/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.LinkDTO;
import run.halo.app.model.vo.LinkTeamVO;
import run.halo.app.service.LinkService;

@RestController(value="ApiContentLinkController")
@RequestMapping(value={"/api/content/links"})
public class LinkController {
    private final LinkService linkService;

    public LinkController(LinkService linkService) {
        this.linkService = linkService;
    }

    @GetMapping
    @ApiOperation(value="List all links")
    public List<LinkDTO> listLinks(@SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.linkService.listDtos(sort);
    }

    @GetMapping(value={"team_view"})
    @ApiOperation(value="List all links with team view")
    public List<LinkTeamVO> listTeamVos(Sort sort) {
        return this.linkService.listTeamVos(sort);
    }
}

