/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.MenuDTO;
import run.halo.app.model.vo.MenuVO;
import run.halo.app.service.MenuService;

@RestController(value="ApiContentMenuController")
@RequestMapping(value={"/api/content/menus"})
public class MenuController {
    private final MenuService menuService;

    public MenuController(MenuService menuService) {
        this.menuService = menuService;
    }

    @GetMapping
    @ApiOperation(value="Lists all menus")
    public List<MenuDTO> listAll(@SortDefault(sort={"priority"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.menuService.listDtos(sort);
    }

    @GetMapping(value={"tree_view"})
    @ApiOperation(value="Lists menus with tree view")
    public List<MenuVO> listMenusTree(@SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.menuService.listAsTree(sort);
    }
}

