/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.OptionDTO;
import run.halo.app.model.properties.CommentProperties;
import run.halo.app.model.support.BaseResponse;
import run.halo.app.service.ClientOptionService;

@RestController(value="ApiContentOptionController")
@RequestMapping(value={"/api/content/options"})
public class OptionController {
    private final ClientOptionService optionService;

    public OptionController(ClientOptionService clientOptionService) {
        this.optionService = clientOptionService;
    }

    @GetMapping(value={"list_view"})
    @ApiOperation(value="Lists all options with list view")
    public List<OptionDTO> listAll() {
        return this.optionService.listDtos();
    }

    @GetMapping(value={"map_view"})
    @ApiOperation(value="Lists options with map view")
    public Map<String, Object> listAllWithMapView(@Deprecated(since="1.4.8", forRemoval=true) @RequestParam(value="key", required=false) List<String> keyList, @RequestParam(value="keys", required=false) String keys) {
        if (!CollectionUtils.isEmpty(keyList)) {
            return this.optionService.listOptions(keyList);
        }
        if (StringUtils.hasText((String)keys)) {
            Set nameSet = Arrays.stream(keys.split(",")).map(String::trim).collect(Collectors.toUnmodifiableSet());
            return this.optionService.listOptions(nameSet);
        }
        return this.optionService.listOptions();
    }

    @GetMapping(value={"keys/{key}"})
    @ApiOperation(value="Gets option value by option key")
    public BaseResponse<Object> getBy(@PathVariable(value="key") String key) {
        Object optionValue = this.optionService.getByKey(key).orElse(null);
        return BaseResponse.ok(optionValue);
    }

    @GetMapping(value={"comment"})
    @ApiOperation(value="Options for comment(@deprecated, use /bulk api instead of this.)")
    @Deprecated
    public Map<String, Object> comment() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(CommentProperties.GRAVATAR_DEFAULT.getValue());
        keys.add(CommentProperties.CONTENT_PLACEHOLDER.getValue());
        keys.add(CommentProperties.GRAVATAR_SOURCE.getValue());
        return this.optionService.listOptions(keys);
    }
}

