/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.PhotoDTO;
import run.halo.app.model.params.PhotoQuery;
import run.halo.app.service.PhotoService;

@RestController(value="ApiContentPhotoController")
@RequestMapping(value={"/api/content/photos"})
public class PhotoController {
    private final PhotoService photoService;

    public PhotoController(PhotoService photoService) {
        this.photoService = photoService;
    }

    @GetMapping(value={"latest"})
    public List<PhotoDTO> listPhotos(@SortDefault(sort={"updateTime"}, direction=Sort.Direction.DESC) Sort sort) {
        return this.photoService.listDtos(sort);
    }

    @GetMapping
    public Page<PhotoDTO> pageBy(@PageableDefault(sort={"updateTime"}, direction=Sort.Direction.DESC) Pageable pageable, PhotoQuery photoQuery) {
        return this.photoService.pageDtosBy(pageable, photoQuery);
    }

    @GetMapping(value={"teams"})
    @ApiOperation(value="Lists all of photo teams")
    public List<String> listTeams() {
        return this.photoService.listAllTeams();
    }
}

