/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.cache.lock.CacheParam;
import run.halo.app.controller.content.auth.PostAuthentication;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.dto.post.BasePostSimpleDTO;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.params.BaseCommentParam;
import run.halo.app.model.params.PostCommentParam;
import run.halo.app.model.params.PostQuery;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.model.vo.CommentWithHasChildrenVO;
import run.halo.app.model.vo.PostDetailVO;
import run.halo.app.model.vo.PostListVO;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostService;
import run.halo.app.service.assembler.PostRenderAssembler;
import run.halo.app.service.assembler.comment.PostCommentRenderAssembler;

@RestController(value="ApiContentPostController")
@RequestMapping(value={"/api/content/posts"})
public class PostController {
    private final PostService postService;
    private final PostCommentRenderAssembler postCommentRenderAssembler;
    private final PostCommentService postCommentService;
    private final OptionService optionService;
    private final PostRenderAssembler postRenderAssembler;
    private final PostAuthentication postAuthentication;

    public PostController(PostService postService, PostCommentRenderAssembler postCommentRenderAssembler, PostCommentService postCommentService, OptionService optionService, PostRenderAssembler postRenderAssembler, PostAuthentication postAuthentication) {
        this.postService = postService;
        this.postCommentRenderAssembler = postCommentRenderAssembler;
        this.postCommentService = postCommentService;
        this.optionService = optionService;
        this.postRenderAssembler = postRenderAssembler;
        this.postAuthentication = postAuthentication;
    }

    @GetMapping
    @ApiOperation(value="Lists posts")
    public Page<PostListVO> pageBy(@PageableDefault(sort={"topPriority", "createTime"}, direction=Sort.Direction.DESC) Pageable pageable, @RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="categoryId", required=false) Integer categoryId) {
        PostQuery postQuery = new PostQuery();
        postQuery.setKeyword(keyword);
        postQuery.setCategoryId(categoryId);
        postQuery.setStatuses(Set.of(PostStatus.PUBLISHED));
        Page postPage = this.postService.pageBy(postQuery, pageable);
        return this.postRenderAssembler.convertToListVo(postPage);
    }

    @PostMapping(value={"search"})
    @ApiOperation(value="Lists posts by keyword")
    public Page<BasePostSimpleDTO> pageBy(@RequestParam(value="keyword") String keyword, @PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Page postPage = this.postService.pageBy(keyword, pageable);
        return this.postRenderAssembler.convertToSimple(postPage);
    }

    @GetMapping(value={"{postId:\\d+}"})
    @ApiOperation(value="Gets a post")
    public PostDetailVO getBy(@PathVariable(value="postId") Integer postId, @RequestParam(value="formatDisabled", required=false, defaultValue="true") Boolean formatDisabled, @RequestParam(value="sourceDisabled", required=false, defaultValue="false") Boolean sourceDisabled) {
        Post post = (Post)this.postService.getById((Object)postId);
        this.checkAuthenticate(postId);
        PostDetailVO postDetailVO = this.postRenderAssembler.convertToDetailVo(post);
        if (formatDisabled.booleanValue()) {
            postDetailVO.setContent(null);
        }
        if (sourceDisabled.booleanValue()) {
            postDetailVO.setOriginalContent(null);
        }
        this.postService.publishVisitEvent(postDetailVO.getId());
        return postDetailVO;
    }

    @GetMapping(value={"/slug"})
    @ApiOperation(value="Gets a post")
    public PostDetailVO getBy(@RequestParam(value="slug") String slug, @RequestParam(value="formatDisabled", required=false, defaultValue="true") Boolean formatDisabled, @RequestParam(value="sourceDisabled", required=false, defaultValue="false") Boolean sourceDisabled) {
        Post post = (Post)this.postService.getBySlug(slug);
        this.checkAuthenticate(post.getId());
        PostDetailVO postDetailVO = this.postRenderAssembler.convertToDetailVo(post);
        if (formatDisabled.booleanValue()) {
            postDetailVO.setContent(null);
        }
        if (sourceDisabled.booleanValue()) {
            postDetailVO.setOriginalContent(null);
        }
        this.postService.publishVisitEvent(postDetailVO.getId());
        return postDetailVO;
    }

    @GetMapping(value={"{postId:\\d+}/prev"})
    @ApiOperation(value="Gets previous post by current post id.")
    public PostDetailVO getPrevPostBy(@PathVariable(value="postId") Integer postId) {
        Post post = (Post)this.postService.getById((Object)postId);
        Post prevPost = (Post)this.postService.getPrevPost((BasePost)post).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f"));
        this.checkAuthenticate(prevPost.getId());
        return this.postRenderAssembler.convertToDetailVo(prevPost);
    }

    @GetMapping(value={"{postId:\\d+}/next"})
    @ApiOperation(value="Gets next post by current post id.")
    public PostDetailVO getNextPostBy(@PathVariable(value="postId") Integer postId) {
        Post post = (Post)this.postService.getById((Object)postId);
        Post nextPost = (Post)this.postService.getNextPost((BasePost)post).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f"));
        this.checkAuthenticate(nextPost.getId());
        return this.postRenderAssembler.convertToDetailVo(nextPost);
    }

    @GetMapping(value={"{postId:\\d+}/comments/top_view"})
    public Page<CommentWithHasChildrenVO> listTopComments(@PathVariable(value="postId") Integer postId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        this.checkAuthenticate(postId);
        Page comments = this.postCommentService.pageTopCommentsBy(postId, CommentStatus.PUBLISHED, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.getContent().forEach(arg_0 -> ((PostCommentRenderAssembler)this.postCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @GetMapping(value={"{postId:\\d+}/comments/{commentParentId:\\d+}/children"})
    public List<BaseCommentDTO> listChildrenBy(@PathVariable(value="postId") Integer postId, @PathVariable(value="commentParentId") Long commentParentId, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        this.checkAuthenticate(postId);
        List postComments = this.postCommentService.listChildrenBy(postId, commentParentId, CommentStatus.PUBLISHED, sort);
        return this.postCommentRenderAssembler.convertTo(postComments);
    }

    @GetMapping(value={"{postId:\\d+}/comments/tree_view"})
    @ApiOperation(value="Lists comments with tree view")
    public Page<BaseCommentVO> listCommentsTree(@PathVariable(value="postId") Integer postId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        this.checkAuthenticate(postId);
        Page comments = this.postCommentService.pageVosBy(postId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.getContent().forEach(arg_0 -> ((PostCommentRenderAssembler)this.postCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @GetMapping(value={"{postId:\\d+}/comments/list_view"})
    @ApiOperation(value="Lists comment with list view")
    public Page<BaseCommentWithParentVO> listComments(@PathVariable(value="postId") Integer postId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        this.checkAuthenticate(postId);
        Page comments = this.postCommentService.pageWithParentVoBy(postId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.getContent().forEach(arg_0 -> ((PostCommentRenderAssembler)this.postCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @PostMapping(value={"comments"})
    @ApiOperation(value="Comments a post")
    @CacheLock(autoDelete=false, traceRequest=true)
    public BaseCommentDTO comment(@RequestBody PostCommentParam postCommentParam) {
        this.checkAuthenticate(postCommentParam.getPostId());
        this.postCommentService.validateCommentBlackListStatus();
        postCommentParam.setContent(HtmlUtils.htmlEscape((String)postCommentParam.getContent(), (String)StandardCharsets.UTF_8.displayName()));
        return this.postCommentRenderAssembler.convertTo((PostComment)this.postCommentService.createBy((BaseCommentParam)postCommentParam));
    }

    @PostMapping(value={"{postId:\\d+}/likes"})
    @ApiOperation(value="Likes a post")
    @CacheLock(autoDelete=false, traceRequest=true)
    public void like(@PathVariable(value="postId") @CacheParam Integer postId) {
        this.checkAuthenticate(postId);
        this.postService.increaseLike(postId);
    }

    private void checkAuthenticate(Integer postId) {
        if (!this.postAuthentication.isAuthenticated(postId)) {
            throw new ForbiddenException("\u60a8\u6ca1\u6709\u8be5\u5206\u7c7b\u7684\u8bbf\u95ee\u6743\u9650");
        }
    }
}

