/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.model.dto.BaseCommentDTO;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.entity.SheetComment;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.params.BaseCommentParam;
import run.halo.app.model.params.SheetCommentParam;
import run.halo.app.model.vo.BaseCommentVO;
import run.halo.app.model.vo.BaseCommentWithParentVO;
import run.halo.app.model.vo.CommentWithHasChildrenVO;
import run.halo.app.model.vo.SheetDetailVO;
import run.halo.app.model.vo.SheetListVO;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.SheetService;
import run.halo.app.service.assembler.SheetRenderAssembler;
import run.halo.app.service.assembler.comment.SheetCommentRenderAssembler;

@RestController(value="ApiContentSheetController")
@RequestMapping(value={"/api/content/sheets"})
public class SheetController {
    private final SheetCommentRenderAssembler sheetCommentRenderAssembler;
    private final SheetService sheetService;
    private final SheetRenderAssembler sheetRenderAssembler;
    private final SheetCommentService sheetCommentService;
    private final OptionService optionService;

    public SheetController(SheetCommentRenderAssembler sheetCommentRenderAssembler, SheetService sheetService, SheetRenderAssembler sheetRenderAssembler, SheetCommentService sheetCommentService, OptionService optionService) {
        this.sheetCommentRenderAssembler = sheetCommentRenderAssembler;
        this.sheetService = sheetService;
        this.sheetRenderAssembler = sheetRenderAssembler;
        this.sheetCommentService = sheetCommentService;
        this.optionService = optionService;
    }

    @GetMapping
    @ApiOperation(value="Lists sheets")
    public Page<SheetListVO> pageBy(@PageableDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Page sheetPage = this.sheetService.pageBy(PostStatus.PUBLISHED, pageable);
        return this.sheetRenderAssembler.convertToListVo(sheetPage);
    }

    @GetMapping(value={"{sheetId:\\d+}"})
    @ApiOperation(value="Gets a sheet")
    public SheetDetailVO getBy(@PathVariable(value="sheetId") Integer sheetId, @RequestParam(value="formatDisabled", required=false, defaultValue="true") Boolean formatDisabled, @RequestParam(value="sourceDisabled", required=false, defaultValue="false") Boolean sourceDisabled) {
        Sheet sheet = (Sheet)this.sheetService.getById((Object)sheetId);
        SheetDetailVO sheetDetailVO = this.sheetRenderAssembler.convertToDetailVo(sheet);
        if (formatDisabled.booleanValue()) {
            sheetDetailVO.setContent(null);
        }
        if (sourceDisabled.booleanValue()) {
            sheetDetailVO.setOriginalContent(null);
        }
        this.sheetService.publishVisitEvent(sheetDetailVO.getId());
        return sheetDetailVO;
    }

    @GetMapping(value={"/slug"})
    @ApiOperation(value="Gets a sheet by slug")
    public SheetDetailVO getBy(@RequestParam(value="slug") String slug, @RequestParam(value="formatDisabled", required=false, defaultValue="true") Boolean formatDisabled, @RequestParam(value="sourceDisabled", required=false, defaultValue="false") Boolean sourceDisabled) {
        Sheet sheet = (Sheet)this.sheetService.getBySlug(slug);
        SheetDetailVO sheetDetailVO = this.sheetRenderAssembler.convertToDetailVo(sheet);
        if (formatDisabled.booleanValue()) {
            sheetDetailVO.setContent(null);
        }
        if (sourceDisabled.booleanValue()) {
            sheetDetailVO.setOriginalContent(null);
        }
        this.sheetService.publishVisitEvent(sheetDetailVO.getId());
        return sheetDetailVO;
    }

    @GetMapping(value={"{sheetId:\\d+}/comments/top_view"})
    public Page<CommentWithHasChildrenVO> listTopComments(@PathVariable(value="sheetId") Integer sheetId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        Page comments = this.sheetCommentService.pageTopCommentsBy(sheetId, CommentStatus.PUBLISHED, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.forEach(arg_0 -> ((SheetCommentRenderAssembler)this.sheetCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @GetMapping(value={"{sheetId:\\d+}/comments/{commentParentId:\\d+}/children"})
    public List<BaseCommentDTO> listChildrenBy(@PathVariable(value="sheetId") Integer sheetId, @PathVariable(value="commentParentId") Long commentParentId, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        List sheetComments = this.sheetCommentService.listChildrenBy(sheetId, commentParentId, CommentStatus.PUBLISHED, sort);
        return this.sheetCommentRenderAssembler.convertTo(sheetComments);
    }

    @GetMapping(value={"{sheetId:\\d+}/comments/tree_view"})
    @ApiOperation(value="Lists comments with tree view")
    public Page<BaseCommentVO> listCommentsTree(@PathVariable(value="sheetId") Integer sheetId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        Page comments = this.sheetCommentService.pageVosBy(sheetId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.getContent().forEach(arg_0 -> ((SheetCommentRenderAssembler)this.sheetCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @GetMapping(value={"{sheetId:\\d+}/comments/list_view"})
    @ApiOperation(value="Lists comment with list view")
    public Page<BaseCommentWithParentVO> listComments(@PathVariable(value="sheetId") Integer sheetId, @RequestParam(name="page", required=false, defaultValue="0") int page, @SortDefault(sort={"createTime"}, direction=Sort.Direction.DESC) Sort sort) {
        Page comments = this.sheetCommentService.pageWithParentVoBy(sheetId, (Pageable)PageRequest.of((int)page, (int)this.optionService.getCommentPageSize(), (Sort)sort));
        comments.getContent().forEach(arg_0 -> ((SheetCommentRenderAssembler)this.sheetCommentRenderAssembler).clearSensitiveField(arg_0));
        return comments;
    }

    @PostMapping(value={"comments"})
    @ApiOperation(value="Comments a post")
    @CacheLock(autoDelete=false, traceRequest=true)
    public BaseCommentDTO comment(@RequestBody SheetCommentParam sheetCommentParam) {
        sheetCommentParam.setContent(HtmlUtils.htmlEscape((String)sheetCommentParam.getContent(), (String)StandardCharsets.UTF_8.displayName()));
        return this.sheetCommentRenderAssembler.convertTo((SheetComment)this.sheetCommentService.createBy((BaseCommentParam)sheetCommentParam));
    }
}

