/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.model.dto.TagDTO;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.vo.PostListVO;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;
import run.halo.app.service.assembler.PostRenderAssembler;

@RestController(value="ApiContentTagController")
@RequestMapping(value={"/api/content/tags"})
public class TagController {
    private final TagService tagService;
    private final PostTagService postTagService;
    private final PostRenderAssembler postRenderAssembler;

    public TagController(TagService tagService, PostTagService postTagService, PostRenderAssembler postRenderAssembler) {
        this.tagService = tagService;
        this.postTagService = postTagService;
        this.postRenderAssembler = postRenderAssembler;
    }

    @GetMapping
    @ApiOperation(value="Lists tags")
    public List<? extends TagDTO> listTags(@SortDefault(sort={"updateTime"}, direction=Sort.Direction.DESC) Sort sort, @ApiParam(value="If the param is true, post count of tag will be returned") @RequestParam(name="more", required=false, defaultValue="false") Boolean more) {
        if (more.booleanValue()) {
            return this.postTagService.listTagWithCountDtos(sort);
        }
        return this.tagService.convertTo(this.tagService.listAll(sort));
    }

    @GetMapping(value={"{slug}/posts"})
    @ApiOperation(value="Lists posts by tag slug")
    public Page<PostListVO> listPostsBy(@PathVariable(value="slug") String slug, @PageableDefault(sort={"topPriority", "updateTime"}, direction=Sort.Direction.DESC) Pageable pageable) {
        Tag tag = this.tagService.getBySlugOfNonNull(slug);
        Page postPage = this.postTagService.pagePostsBy(tag.getId(), PostStatus.PUBLISHED, pageable);
        return this.postRenderAssembler.convertToListVo(postPage);
    }
}

