/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.api;

import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.service.ThemeService;
import run.halo.app.service.ThemeSettingService;

@RestController(value="ApiContentThemeController")
@RequestMapping(value={"/api/content/themes"})
public class ThemeController {
    private final ThemeService themeService;
    private final ThemeSettingService themeSettingService;

    public ThemeController(ThemeService themeService, ThemeSettingService themeSettingService) {
        this.themeService = themeService;
        this.themeSettingService = themeSettingService;
    }

    @GetMapping(value={"activation"})
    @ApiOperation(value="Gets activated theme property")
    public ThemeProperty getBy() {
        return this.themeService.getThemeOfNonNullBy(this.themeService.getActivatedThemeId());
    }

    @GetMapping(value={"{themeId:.+}"})
    @ApiOperation(value="Gets theme property by theme id")
    public ThemeProperty getBy(@PathVariable(value="themeId") String themeId) {
        return this.themeService.getThemeOfNonNullBy(themeId);
    }

    @GetMapping(value={"activation/settings"})
    @ApiOperation(value="Lists activated theme settings")
    public Map<String, Object> listSettingsBy() {
        return this.themeSettingService.listAsMapBy(this.themeService.getActivatedThemeId());
    }

    @GetMapping(value={"{themeId:.+}/settings"})
    @ApiOperation(value="Lists theme settings by theme id")
    public Map<String, Object> listSettingsBy(@PathVariable(value="themeId") String themeId) {
        return this.themeSettingService.listAsMapBy(themeId);
    }
}

