/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.auth;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.controller.content.auth.ContentAuthentication;
import run.halo.app.model.entity.Category;
import run.halo.app.model.enums.EncryptTypeEnum;
import run.halo.app.service.CategoryService;

@Component
public class CategoryAuthentication
implements ContentAuthentication {
    private final CategoryService categoryService;
    private final AbstractStringCacheStore cacheStore;

    public CategoryAuthentication(CategoryService categoryService, AbstractStringCacheStore cacheStore) {
        this.categoryService = categoryService;
        this.cacheStore = cacheStore;
    }

    @NonNull
    public Object getPrincipal() {
        return EncryptTypeEnum.CATEGORY.getName();
    }

    public boolean isAuthenticated(Integer categoryId) {
        Category category = (Category)this.categoryService.getById((Object)categoryId);
        if (!this.isPrivate(category)) {
            return true;
        }
        String sessionId = this.getSessionId();
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            return false;
        }
        String cacheKey = this.buildCacheKey(sessionId, this.getPrincipal().toString(), String.valueOf(categoryId));
        return this.cacheStore.get((Object)cacheKey).isPresent();
    }

    private boolean isPrivate(Category category) {
        if (StringUtils.isNotBlank((CharSequence)category.getPassword())) {
            return true;
        }
        return this.categoryService.lookupFirstEncryptedBy(category.getId()).isPresent();
    }

    public void setAuthenticated(Integer resourceId, boolean isAuthenticated) {
        String sessionId = this.getSessionId();
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            return;
        }
        String cacheKey = this.buildCacheKey(sessionId, this.getPrincipal().toString(), String.valueOf(resourceId));
        if (isAuthenticated) {
            this.cacheStore.putAny(cacheKey, (Object)"", 1L, TimeUnit.DAYS);
            return;
        }
        this.cacheStore.delete((Object)cacheKey);
    }

    public void clearByResourceId(Integer resourceId) {
        String sessionId = this.getSessionId();
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return;
        }
        String categoryCacheKey = this.buildCacheKey(sessionId, this.getPrincipal().toString(), String.valueOf(resourceId));
        this.cacheStore.delete((Object)categoryCacheKey);
        Set postIds = this.categoryService.listPostIdsByCategoryIdRecursively(resourceId);
        Set<String> postCacheKeys = postIds.stream().map(postId -> this.buildCacheKey(sessionId, EncryptTypeEnum.POST.getName(), String.valueOf(postId))).collect(Collectors.toSet());
        postCacheKeys.forEach(arg_0 -> ((AbstractStringCacheStore)this.cacheStore).delete(arg_0));
    }
}

