/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.auth;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import run.halo.app.utils.ServletUtils;

public interface ContentAuthentication {
    public static final String CACHE_PREFIX = "CONTENT_AUTHENTICATED";

    public Object getPrincipal();

    public boolean isAuthenticated(Integer var1);

    public void setAuthenticated(Integer var1, boolean var2);

    public void clearByResourceId(Integer var1);

    default public String buildCacheKey(String sessionId, String principal, String value) {
        Assert.notNull((Object)sessionId, (String)"The sessionId must not be null.");
        Assert.notNull((Object)principal, (String)"The principal must not be null.");
        Assert.notNull((Object)value, (String)"The value must not be null.");
        return StringUtils.joinWith((String)":", (Object[])new Object[]{CACHE_PREFIX, principal, value, sessionId});
    }

    default public String getSessionId() {
        Optional currentRequest = ServletUtils.getCurrentRequest();
        if (currentRequest.isEmpty()) {
            return "";
        }
        return ((HttpServletRequest)currentRequest.get()).getRequestedSessionId();
    }
}

