/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.auth;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import run.halo.app.controller.content.auth.CategoryAuthentication;
import run.halo.app.controller.content.auth.ContentAuthentication;
import run.halo.app.controller.content.auth.ContentAuthenticationRequest;
import run.halo.app.controller.content.auth.PostAuthentication;
import run.halo.app.event.category.CategoryUpdatedEvent;
import run.halo.app.event.post.PostUpdatedEvent;
import run.halo.app.exception.AuthenticationException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.Category;
import run.halo.app.model.entity.Post;
import run.halo.app.model.enums.EncryptTypeEnum;
import run.halo.app.service.CategoryService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostService;

@Component
public class ContentAuthenticationManager {
    private final CategoryService categoryService;
    private final CategoryAuthentication categoryAuthentication;
    private final PostService postService;
    private final PostAuthentication postAuthentication;
    private final PostCategoryService postCategoryService;

    public ContentAuthenticationManager(CategoryService categoryService, CategoryAuthentication categoryAuthentication, PostService postService, PostAuthentication postAuthentication, PostCategoryService postCategoryService) {
        this.categoryService = categoryService;
        this.categoryAuthentication = categoryAuthentication;
        this.postService = postService;
        this.postAuthentication = postAuthentication;
        this.postCategoryService = postCategoryService;
    }

    public ContentAuthentication authenticate(ContentAuthenticationRequest authRequest) throws AuthenticationException {
        if (EncryptTypeEnum.POST.getName().equals(authRequest.getPrincipal())) {
            return this.authenticatePost(authRequest);
        }
        if (EncryptTypeEnum.CATEGORY.getName().equals(authRequest.getPrincipal())) {
            return this.authenticateCategory(authRequest);
        }
        throw new NotFoundException("Could not be found suitable authentication processor for [" + authRequest.getPrincipal() + "]");
    }

    @EventListener(value={CategoryUpdatedEvent.class})
    public void categoryUpdatedListener(CategoryUpdatedEvent event) {
        Category category = event.getCategory();
        if (category == null) {
            category = event.getBeforeUpdated();
        }
        if (category != null) {
            this.categoryAuthentication.clearByResourceId(category.getId());
        }
    }

    @EventListener(value={PostUpdatedEvent.class})
    public void postUpdatedListener(PostUpdatedEvent event) {
        Post post = event.getPost();
        if (post != null) {
            this.postAuthentication.clearByResourceId(post.getId());
        }
    }

    private PostAuthentication authenticatePost(ContentAuthenticationRequest authRequest) {
        Post post = (Post)this.postService.getById((Object)authRequest.getId());
        if (StringUtils.isNotBlank((CharSequence)post.getPassword())) {
            if (StringUtils.equals((CharSequence)post.getPassword(), (CharSequence)authRequest.getPassword())) {
                this.postAuthentication.setAuthenticated(post.getId(), true);
                return this.postAuthentication;
            }
            throw new AuthenticationException("\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        List encryptedCategories = this.postCategoryService.listCategoriesBy(post.getId()).stream().filter(category -> this.categoryService.isPrivate(category.getId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(encryptedCategories)) {
            return this.postAuthentication;
        }
        for (Category category2 : encryptedCategories) {
            if (!StringUtils.equals((CharSequence)category2.getPassword(), (CharSequence)authRequest.getPassword())) continue;
            this.postAuthentication.setAuthenticated(post.getId(), true);
            return this.postAuthentication;
        }
        for (Category category2 : encryptedCategories) {
            boolean authenticated = this.categoryService.lookupFirstEncryptedBy(category2.getId()).filter(parentCategory -> StringUtils.equals((CharSequence)parentCategory.getPassword(), (CharSequence)authRequest.getPassword())).isPresent();
            if (!authenticated) continue;
            this.postAuthentication.setAuthenticated(post.getId(), true);
            return this.postAuthentication;
        }
        throw new AuthenticationException("\u5bc6\u7801\u4e0d\u6b63\u786e");
    }

    private CategoryAuthentication authenticateCategory(ContentAuthenticationRequest authRequest) {
        Category category = (Category)this.categoryService.getById((Object)authRequest.getId());
        if (category.getPassword() == null) {
            String parentPassword = this.categoryService.lookupFirstEncryptedBy(category.getId()).map(Category::getPassword).orElse(null);
            if (parentPassword == null) {
                return this.categoryAuthentication;
            }
            category.setPassword(parentPassword);
        }
        if (StringUtils.equals((CharSequence)category.getPassword(), (CharSequence)authRequest.getPassword())) {
            this.categoryAuthentication.setAuthenticated(category.getId(), true);
            return this.categoryAuthentication;
        }
        Category parentCategory = (Category)this.categoryService.lookupFirstEncryptedBy(authRequest.getId()).orElseThrow(() -> new AuthenticationException("\u5bc6\u7801\u4e0d\u6b63\u786e"));
        if (!Objects.equals(parentCategory.getPassword(), authRequest.getPassword())) {
            throw new AuthenticationException("\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        this.categoryAuthentication.setAuthenticated(category.getId(), true);
        return this.categoryAuthentication;
    }
}

