/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.auth;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.controller.content.auth.CategoryAuthentication;
import run.halo.app.controller.content.auth.ContentAuthentication;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.PostCategory;
import run.halo.app.model.enums.EncryptTypeEnum;
import run.halo.app.service.CategoryService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostService;

@Component
public class PostAuthentication
implements ContentAuthentication {
    private final PostService postService;
    private final CategoryService categoryService;
    private final PostCategoryService postCategoryService;
    private final AbstractStringCacheStore cacheStore;
    private final CategoryAuthentication categoryAuthentication;

    public PostAuthentication(PostService postService, CategoryService categoryService, PostCategoryService postCategoryService, AbstractStringCacheStore cacheStore, CategoryAuthentication categoryAuthentication) {
        this.postService = postService;
        this.categoryService = categoryService;
        this.postCategoryService = postCategoryService;
        this.cacheStore = cacheStore;
        this.categoryAuthentication = categoryAuthentication;
    }

    public Object getPrincipal() {
        return EncryptTypeEnum.POST.getName();
    }

    public boolean isAuthenticated(Integer postId) {
        Post post = (Post)this.postService.getById((Object)postId);
        if (!this.isPrivate(post)) {
            return true;
        }
        List postCategories = this.postCategoryService.listByPostId(postId);
        for (PostCategory postCategory : postCategories) {
            if (!this.categoryService.isPrivate(postCategory.getCategoryId()) || !this.categoryAuthentication.isAuthenticated(postCategory.getCategoryId())) continue;
            return true;
        }
        String sessionId = this.getSessionId();
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            return false;
        }
        String cacheKey = this.buildCacheKey(sessionId, this.getPrincipal().toString(), String.valueOf(postId));
        return this.cacheStore.get((Object)cacheKey).isPresent();
    }

    private boolean isPrivate(Post post) {
        if (StringUtils.isNotBlank((CharSequence)post.getPassword())) {
            return true;
        }
        List postCategories = this.postCategoryService.listByPostId(post.getId());
        return postCategories.stream().anyMatch(postCategory -> this.categoryService.isPrivate(postCategory.getCategoryId()));
    }

    public void setAuthenticated(Integer resourceId, boolean isAuthenticated) {
        String sessionId = this.getSessionId();
        if (StringUtils.isEmpty((CharSequence)sessionId)) {
            return;
        }
        String cacheKey = this.buildCacheKey(sessionId, this.getPrincipal().toString(), String.valueOf(resourceId));
        if (isAuthenticated) {
            this.cacheStore.putAny(cacheKey, (Object)"", 1L, TimeUnit.DAYS);
            return;
        }
        this.cacheStore.delete((Object)cacheKey);
    }

    public void clearByResourceId(Integer resourceId) {
        String sessionId = this.getSessionId();
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return;
        }
        String cacheKey = this.buildCacheKey(sessionId, this.getPrincipal().toString(), String.valueOf(resourceId));
        this.cacheStore.delete((Object)cacheKey);
    }
}

