/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import run.halo.app.controller.content.auth.CategoryAuthentication;
import run.halo.app.model.dto.CategoryDTO;
import run.halo.app.model.entity.Category;
import run.halo.app.model.enums.EncryptTypeEnum;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.service.CategoryService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.assembler.PostRenderAssembler;

@Component
public class CategoryModel {
    private final CategoryService categoryService;
    private final ThemeService themeService;
    private final PostCategoryService postCategoryService;
    private final PostRenderAssembler postRenderAssembler;
    private final OptionService optionService;
    private final CategoryAuthentication categoryAuthentication;

    public CategoryModel(CategoryService categoryService, ThemeService themeService, PostCategoryService postCategoryService, PostRenderAssembler postRenderAssembler, OptionService optionService, CategoryAuthentication categoryAuthentication) {
        this.categoryService = categoryService;
        this.themeService = themeService;
        this.postCategoryService = postCategoryService;
        this.postRenderAssembler = postRenderAssembler;
        this.optionService = optionService;
        this.categoryAuthentication = categoryAuthentication;
    }

    public String list(Model model) {
        model.addAttribute("is_categories", (Object)true);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("categories");
    }

    public String listPost(Model model, String slug, Integer page) {
        Category category = this.categoryService.getBySlugOfNonNull(slug);
        if (!this.categoryAuthentication.isAuthenticated(category.getId())) {
            model.addAttribute("slug", (Object)category.getSlug());
            model.addAttribute("type", (Object)EncryptTypeEnum.CATEGORY.getName());
            if (this.themeService.templateExists("post_password.ftl")) {
                return this.themeService.render("post_password");
            }
            return "common/template/post_password";
        }
        ImmutableSet statuses = Sets.immutableEnumSet((Enum)PostStatus.PUBLISHED, (Enum[])new PostStatus[0]);
        if (this.categoryService.isPrivate(category.getId())) {
            statuses = Sets.immutableEnumSet((Enum)PostStatus.INTIMATE, (Enum[])new PostStatus[0]);
        }
        CategoryDTO categoryDTO = this.categoryService.convertTo(category);
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)this.optionService.getArchivesPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"topPriority", "createTime"}));
        Page postPage = this.postCategoryService.pagePostBy(category.getId(), (Set)statuses, (Pageable)pageable);
        Page posts = this.postRenderAssembler.convertToListVo(postPage);
        if (StringUtils.isNotEmpty((CharSequence)category.getDescription())) {
            model.addAttribute("meta_description", (Object)category.getDescription());
        } else {
            model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        }
        model.addAttribute("is_category", (Object)true);
        model.addAttribute("posts", (Object)posts);
        model.addAttribute("category", (Object)categoryDTO);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        return this.themeService.render("category");
    }
}

