/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.model;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import run.halo.app.model.enums.JournalType;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.SheetProperties;
import run.halo.app.service.JournalService;
import run.halo.app.service.OptionService;
import run.halo.app.service.ThemeService;

@Component
public class JournalModel {
    private final JournalService journalService;
    private final OptionService optionService;
    private final ThemeService themeService;

    public JournalModel(JournalService journalService, OptionService optionService, ThemeService themeService) {
        this.journalService = journalService;
        this.optionService = optionService;
        this.themeService = themeService;
    }

    public String list(Integer page, Model model) {
        int pageSize = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)SheetProperties.JOURNALS_PAGE_SIZE, Integer.class, (Object)Integer.parseInt(SheetProperties.JOURNALS_PAGE_SIZE.defaultValue()));
        PageRequest pageable = PageRequest.of((int)(page >= 1 ? page - 1 : page), (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page journals = this.journalService.pageBy(JournalType.PUBLIC, (Pageable)pageable);
        model.addAttribute("is_journals", (Object)true);
        model.addAttribute("journals", (Object)this.journalService.convertToCmtCountDto(journals));
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("journals");
    }
}

