/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.model;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.model.properties.SheetProperties;
import run.halo.app.service.OptionService;
import run.halo.app.service.PhotoService;
import run.halo.app.service.ThemeService;

@Component
public class PhotoModel {
    private final PhotoService photoService;
    private final ThemeService themeService;
    private final OptionService optionService;

    public PhotoModel(PhotoService photoService, ThemeService themeService, OptionService optionService) {
        this.photoService = photoService;
        this.themeService = themeService;
        this.optionService = optionService;
    }

    public String list(Integer page, Model model) {
        int pageSize = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)SheetProperties.PHOTOS_PAGE_SIZE, Integer.class, (Object)Integer.parseInt(SheetProperties.PHOTOS_PAGE_SIZE.defaultValue()));
        PageRequest pageable = PageRequest.of((int)(page >= 1 ? page - 1 : page), (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page photos = this.photoService.pageBy((Pageable)pageable);
        model.addAttribute("is_photos", (Object)true);
        model.addAttribute("photos", (Object)photos);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("photos");
    }
}

