/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.model;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.controller.content.auth.PostAuthentication;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.entity.Post;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.enums.EncryptTypeEnum;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.service.CategoryService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostMetaService;
import run.halo.app.service.PostService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.assembler.PostRenderAssembler;

@Component
public class PostModel {
    private final PostRenderAssembler postRenderAssembler;
    private final PostService postService;
    private final ThemeService themeService;
    private final PostCategoryService postCategoryService;
    private final CategoryService categoryService;
    private final PostTagService postTagService;
    private final TagService tagService;
    private final PostMetaService postMetaService;
    private final OptionService optionService;
    private final AbstractStringCacheStore cacheStore;
    private final PostAuthentication postAuthentication;

    public PostModel(PostRenderAssembler postRenderAssembler, PostService postService, ThemeService themeService, PostCategoryService postCategoryService, CategoryService categoryService, PostMetaService postMetaService, PostTagService postTagService, TagService tagService, OptionService optionService, AbstractStringCacheStore cacheStore, PostAuthentication postAuthentication) {
        this.postRenderAssembler = postRenderAssembler;
        this.postService = postService;
        this.themeService = themeService;
        this.postCategoryService = postCategoryService;
        this.categoryService = categoryService;
        this.postMetaService = postMetaService;
        this.postTagService = postTagService;
        this.tagService = tagService;
        this.optionService = optionService;
        this.cacheStore = cacheStore;
        this.postAuthentication = postAuthentication;
    }

    public String content(Post post, String token, Model model) {
        if (PostStatus.RECYCLE.equals((Object)post.getStatus())) {
            throw new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f");
        }
        if (StringUtils.isNotBlank((CharSequence)token)) {
            String cachedToken = (String)this.cacheStore.getAny(token, String.class).orElseThrow(() -> new ForbiddenException("\u60a8\u6ca1\u6709\u8be5\u6587\u7ae0\u7684\u8bbf\u95ee\u6743\u9650"));
            if (!cachedToken.equals(token)) {
                throw new ForbiddenException("\u60a8\u6ca1\u6709\u8be5\u6587\u7ae0\u7684\u8bbf\u95ee\u6743\u9650");
            }
        } else {
            if (PostStatus.DRAFT.equals((Object)post.getStatus())) {
                throw new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6587\u7ae0\u7684\u4fe1\u606f");
            }
            if (PostStatus.INTIMATE.equals((Object)post.getStatus()) && !this.postAuthentication.isAuthenticated(post.getId())) {
                model.addAttribute("slug", (Object)post.getSlug());
                model.addAttribute("type", (Object)EncryptTypeEnum.POST.getName());
                if (this.themeService.templateExists("post_password.ftl")) {
                    return this.themeService.render("post_password");
                }
                return "common/template/post_password";
            }
        }
        post = (Post)this.postService.getById((Object)post.getId());
        this.postService.publishVisitEvent(post.getId());
        this.postService.getPrevPost((BasePost)post).ifPresent(prevPost -> model.addAttribute("prevPost", (Object)this.postRenderAssembler.convertToDetailVo(prevPost)));
        this.postService.getNextPost((BasePost)post).ifPresent(nextPost -> model.addAttribute("nextPost", (Object)this.postRenderAssembler.convertToDetailVo(nextPost)));
        List categories = this.postCategoryService.listCategoriesBy(post.getId());
        List tags = this.postTagService.listTagsBy(post.getId());
        List metas = this.postMetaService.listBy(post.getId());
        if (StringUtils.isNotEmpty((CharSequence)post.getMetaKeywords())) {
            model.addAttribute("meta_keywords", (Object)post.getMetaKeywords());
        } else {
            model.addAttribute("meta_keywords", (Object)tags.stream().map(Tag::getName).collect(Collectors.joining(",")));
        }
        if (StringUtils.isNotEmpty((CharSequence)post.getMetaDescription())) {
            model.addAttribute("meta_description", (Object)post.getMetaDescription());
        } else {
            model.addAttribute("meta_description", (Object)this.postService.generateDescription(post.getContent().getContent()));
        }
        model.addAttribute("is_post", (Object)true);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            model.addAttribute("post", (Object)this.postRenderAssembler.convertToPreviewDetailVo(post));
        } else {
            model.addAttribute("post", (Object)this.postRenderAssembler.convertToDetailVo(post));
        }
        model.addAttribute("categories", (Object)this.categoryService.convertTo(categories));
        model.addAttribute("tags", (Object)this.tagService.convertTo(tags));
        model.addAttribute("metas", (Object)this.postMetaService.convertToMap(metas));
        if (this.themeService.templateExists("post_" + post.getTemplate() + ".ftl")) {
            return this.themeService.render("post_" + post.getTemplate());
        }
        return this.themeService.render("post");
    }

    public String list(Integer page, Model model) {
        int pageSize = this.optionService.getPostPageSize();
        PageRequest pageable = PageRequest.of((int)(page >= 1 ? page - 1 : page), (int)pageSize, (Sort)this.postService.getPostDefaultSort());
        Page postPage = this.postService.pageBy(PostStatus.PUBLISHED, (Pageable)pageable);
        Page posts = this.postRenderAssembler.convertToListVo(postPage);
        model.addAttribute("is_index", (Object)true);
        model.addAttribute("posts", (Object)posts);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("index");
    }

    public String archives(Integer page, Model model) {
        int pageSize = this.optionService.getArchivesPageSize();
        PageRequest pageable = PageRequest.of((int)(page >= 1 ? page - 1 : page), (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page postPage = this.postService.pageBy(PostStatus.PUBLISHED, (Pageable)pageable);
        Page posts = this.postRenderAssembler.convertToListVo(postPage);
        List archives = this.postRenderAssembler.convertToYearArchives(postPage.getContent());
        model.addAttribute("is_archives", (Object)true);
        model.addAttribute("posts", (Object)posts);
        model.addAttribute("archives", (Object)archives);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("archives");
    }
}

