/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.model;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import run.halo.app.cache.AbstractStringCacheStore;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.model.entity.Sheet;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.vo.SheetDetailVO;
import run.halo.app.service.OptionService;
import run.halo.app.service.SheetMetaService;
import run.halo.app.service.SheetService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.assembler.SheetRenderAssembler;

@Component
public class SheetModel {
    private final SheetService sheetService;
    private final SheetRenderAssembler sheetRenderAssembler;
    private final SheetMetaService sheetMetaService;
    private final AbstractStringCacheStore cacheStore;
    private final ThemeService themeService;
    private final OptionService optionService;

    public SheetModel(SheetService sheetService, SheetRenderAssembler sheetRenderAssembler, SheetMetaService sheetMetaService, AbstractStringCacheStore cacheStore, ThemeService themeService, OptionService optionService) {
        this.sheetService = sheetService;
        this.sheetRenderAssembler = sheetRenderAssembler;
        this.sheetMetaService = sheetMetaService;
        this.cacheStore = cacheStore;
        this.themeService = themeService;
        this.optionService = optionService;
    }

    public String content(Sheet sheet, String token, Model model) {
        SheetDetailVO sheetDetailVo;
        if (StringUtils.isEmpty((CharSequence)token)) {
            sheet = this.sheetService.getBy(PostStatus.PUBLISHED, sheet.getSlug());
            sheetDetailVo = this.sheetRenderAssembler.convertToDetailVo(sheet);
        } else {
            String cachedToken = (String)this.cacheStore.getAny(token, String.class).orElseThrow(() -> new ForbiddenException("\u60a8\u6ca1\u6709\u8be5\u9875\u9762\u7684\u8bbf\u95ee\u6743\u9650"));
            if (!cachedToken.equals(token)) {
                throw new ForbiddenException("\u60a8\u6ca1\u6709\u8be5\u9875\u9762\u7684\u8bbf\u95ee\u6743\u9650");
            }
            sheetDetailVo = this.sheetRenderAssembler.convertToPreviewDetailVo(sheet);
        }
        this.sheetService.publishVisitEvent(sheet.getId());
        List metas = this.sheetMetaService.listBy(sheet.getId());
        if (StringUtils.isNotEmpty((CharSequence)sheet.getMetaKeywords())) {
            model.addAttribute("meta_keywords", (Object)sheet.getMetaKeywords());
        } else {
            model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        }
        if (StringUtils.isNotEmpty((CharSequence)sheet.getMetaDescription())) {
            model.addAttribute("meta_description", (Object)sheet.getMetaDescription());
        } else {
            model.addAttribute("meta_description", (Object)this.sheetService.generateDescription(sheet.getContent().getContent()));
        }
        model.addAttribute("sheet", (Object)sheetDetailVo);
        model.addAttribute("post", (Object)sheetDetailVo);
        model.addAttribute("is_sheet", (Object)true);
        model.addAttribute("metas", (Object)this.sheetMetaService.convertToMap(metas));
        if (this.themeService.templateExists("sheet_" + sheet.getTemplate() + ".ftl")) {
            return this.themeService.render("sheet_" + sheet.getTemplate());
        }
        return this.themeService.render("sheet");
    }
}

