/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.content.model;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import run.halo.app.model.dto.TagDTO;
import run.halo.app.model.entity.Tag;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;
import run.halo.app.service.ThemeService;
import run.halo.app.service.assembler.PostRenderAssembler;

@Component
public class TagModel {
    private final TagService tagService;
    private final PostRenderAssembler postRenderAssembler;
    private final PostTagService postTagService;
    private final OptionService optionService;
    private final ThemeService themeService;

    public TagModel(TagService tagService, PostRenderAssembler postRenderAssembler, PostTagService postTagService, OptionService optionService, ThemeService themeService) {
        this.tagService = tagService;
        this.postRenderAssembler = postRenderAssembler;
        this.postTagService = postTagService;
        this.optionService = optionService;
        this.themeService = themeService;
    }

    public String list(Model model) {
        model.addAttribute("is_tags", (Object)true);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("tags");
    }

    public String listPost(Model model, String slug, Integer page) {
        Tag tag = this.tagService.getBySlugOfNonNull(slug);
        TagDTO tagDTO = this.tagService.convertTo(tag);
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)this.optionService.getArchivesPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        Page postPage = this.postTagService.pagePostsBy(tag.getId(), PostStatus.PUBLISHED, (Pageable)pageable);
        Page posts = this.postRenderAssembler.convertToListVo(postPage);
        model.addAttribute("is_tag", (Object)true);
        model.addAttribute("posts", (Object)posts);
        model.addAttribute("tag", (Object)tagDTO);
        model.addAttribute("meta_keywords", (Object)this.optionService.getSeoKeywords());
        model.addAttribute("meta_description", (Object)this.optionService.getSeoDescription());
        return this.themeService.render("tag");
    }
}

