/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.error;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.util.NestedServletException;
import run.halo.app.exception.AbstractHaloException;

@Component
public class DefaultErrorController
extends BasicErrorController {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorController.class);

    public DefaultErrorController(ErrorAttributes errorAttributes, ServerProperties serverProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, serverProperties.getError(), errorViewResolvers);
    }

    protected HttpStatus getStatus(HttpServletRequest request) {
        HttpStatus status = super.getStatus(request);
        Object exception = request.getAttribute("javax.servlet.error.exception");
        if (exception instanceof NestedServletException) {
            NestedServletException nse = (NestedServletException)exception;
            if (nse.getCause() instanceof AbstractHaloException) {
                status = this.resolveHaloException((AbstractHaloException)nse.getCause(), request);
            }
        } else if (exception instanceof AbstractHaloException) {
            status = this.resolveHaloException((AbstractHaloException)exception, request);
        }
        return status;
    }

    private HttpStatus resolveHaloException(AbstractHaloException haloException, HttpServletRequest request) {
        HttpStatus status = haloException.getStatus();
        if (log.isDebugEnabled()) {
            log.error("Halo exception occurred.", (Throwable)haloException);
        }
        request.setAttribute("javax.servlet.error.status_code", (Object)status.value());
        request.setAttribute("javax.servlet.error.exception", (Object)haloException);
        request.setAttribute("javax.servlet.error.message", (Object)haloException.getMessage());
        request.setAttribute("javax.servlet.error.exception_type", haloException.getClass());
        return status;
    }
}

