/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.controller.error;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;
import run.halo.app.service.ThemeService;

@Component
public class DefaultErrorViewResolver
implements ErrorViewResolver {
    private static final Map<HttpStatus.Series, String> SERIES_VIEWS;
    private final ThemeService themeService;
    private final TemplateAvailabilityProviders templateAvailabilityProviders;
    private final ApplicationContext applicationContext;

    public DefaultErrorViewResolver(ThemeService themeService, ApplicationContext applicationContext) {
        this.themeService = themeService;
        this.applicationContext = applicationContext;
        this.templateAvailabilityProviders = new TemplateAvailabilityProviders(applicationContext);
    }

    public ModelAndView resolveErrorView(HttpServletRequest request, HttpStatus status, Map<String, Object> model) {
        HashMap<String, Object> errorModel = new HashMap<String, Object>(model);
        ModelAndView modelAndView = this.resolve(String.valueOf(status.value()), errorModel);
        if (modelAndView == null && SERIES_VIEWS.containsKey(status.series())) {
            modelAndView = this.resolve((String)SERIES_VIEWS.get(status.series()), errorModel);
        }
        if (modelAndView == null) {
            modelAndView = this.resolve("error", errorModel);
        }
        if (modelAndView == null) {
            modelAndView = new ModelAndView("common/error/error", errorModel);
        }
        return modelAndView;
    }

    private ModelAndView resolve(String viewName, Map<String, Object> model) {
        String errorViewName = this.themeService.render(viewName);
        TemplateAvailabilityProvider provider = this.templateAvailabilityProviders.getProvider(errorViewName, this.applicationContext);
        if (provider != null) {
            return new ModelAndView(errorViewName, model);
        }
        return null;
    }

    static {
        EnumMap<HttpStatus.Series, String> views = new EnumMap<HttpStatus.Series, String>(HttpStatus.Series.class);
        views.put(HttpStatus.Series.CLIENT_ERROR, "4xx");
        views.put(HttpStatus.Series.SERVER_ERROR, "5xx");
        SERIES_VIEWS = Collections.unmodifiableMap(views);
    }
}

