/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core;

import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import run.halo.app.model.support.BaseResponse;

@ControllerAdvice(value={"run.halo.app.controller"})
public class CommonResultControllerAdvice
implements ResponseBodyAdvice<Object> {
    public boolean supports(MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        return AbstractJackson2HttpMessageConverter.class.isAssignableFrom(converterType);
    }

    @NonNull
    public final Object beforeBodyWrite(@Nullable Object body, @NonNull MethodParameter returnType, @NonNull MediaType contentType, @NonNull Class<? extends HttpMessageConverter<?>> converterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        MappingJacksonValue container = this.getOrCreateContainer(body);
        this.beforeBodyWriteInternal(container, contentType, returnType, request, response);
        return container;
    }

    private MappingJacksonValue getOrCreateContainer(Object body) {
        return body instanceof MappingJacksonValue ? (MappingJacksonValue)body : new MappingJacksonValue(body);
    }

    private void beforeBodyWriteInternal(MappingJacksonValue bodyContainer, MediaType contentType, MethodParameter returnType, ServerHttpRequest request, ServerHttpResponse response) {
        HttpServletResponse servletResponse;
        Object returnBody = bodyContainer.getValue();
        if (returnBody instanceof BaseResponse) {
            BaseResponse baseResponse = (BaseResponse)returnBody;
            HttpStatus status = HttpStatus.resolve((int)baseResponse.getStatus());
            if (status == null) {
                status = HttpStatus.INTERNAL_SERVER_ERROR;
            }
            response.setStatusCode(status);
            return;
        }
        HttpStatus status = HttpStatus.OK;
        if (response instanceof ServletServerHttpResponse && (status = HttpStatus.resolve((int)(servletResponse = ((ServletServerHttpResponse)response).getServletResponse()).getStatus())) == null) {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        BaseResponse baseResponse = new BaseResponse(Integer.valueOf(status.value()), status.getReasonPhrase(), returnBody);
        bodyContainer.setValue((Object)baseResponse);
    }
}

