/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;
import run.halo.app.exception.AbstractHaloException;
import run.halo.app.model.support.BaseResponse;
import run.halo.app.utils.ExceptionUtils;
import run.halo.app.utils.ValidationUtils;

@RestControllerAdvice(value={"run.halo.app.controller.admin.api", "run.halo.app.controller.content.api"})
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public BaseResponse<?> handleDataIntegrityViolationException(DataIntegrityViolationException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        if (e.getCause() instanceof ConstraintViolationException) {
            baseResponse = this.handleBaseException(e.getCause());
        }
        baseResponse.setMessage("\u5b57\u6bb5\u9a8c\u8bc1\u9519\u8bef\uff0c\u8bf7\u5b8c\u5584\u540e\u91cd\u8bd5\uff01");
        return baseResponse;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public BaseResponse<?> handleMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        baseResponse.setMessage(String.format("\u8bf7\u6c42\u5b57\u6bb5\u7f3a\u5931, \u7c7b\u578b\u4e3a %s\uff0c\u540d\u79f0\u4e3a %s", e.getParameterType(), e.getParameterName()));
        return baseResponse;
    }

    @ExceptionHandler(value={javax.validation.ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public BaseResponse<?> handleConstraintViolationException(javax.validation.ConstraintViolationException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        baseResponse.setStatus(Integer.valueOf(HttpStatus.BAD_REQUEST.value()));
        baseResponse.setMessage("\u5b57\u6bb5\u9a8c\u8bc1\u9519\u8bef\uff0c\u8bf7\u5b8c\u5584\u540e\u91cd\u8bd5\uff01");
        baseResponse.setData((Object)ValidationUtils.mapWithValidError((Set)e.getConstraintViolations()));
        return baseResponse;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public BaseResponse<?> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        baseResponse.setStatus(Integer.valueOf(HttpStatus.BAD_REQUEST.value()));
        baseResponse.setMessage("\u5b57\u6bb5\u9a8c\u8bc1\u9519\u8bef\uff0c\u8bf7\u5b8c\u5584\u540e\u91cd\u8bd5\uff01");
        Map errMap = ValidationUtils.mapWithFieldError((List)e.getBindingResult().getFieldErrors());
        baseResponse.setData((Object)errMap);
        return baseResponse;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public BaseResponse<?> handleHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        baseResponse.setStatus(Integer.valueOf(HttpStatus.BAD_REQUEST.value()));
        return baseResponse;
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public BaseResponse<?> handleHttpMediaTypeNotAcceptableException(HttpMediaTypeNotAcceptableException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        baseResponse.setStatus(Integer.valueOf(HttpStatus.NOT_ACCEPTABLE.value()));
        return baseResponse;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public BaseResponse<?> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        baseResponse.setStatus(Integer.valueOf(HttpStatus.BAD_REQUEST.value()));
        baseResponse.setMessage("\u7f3a\u5931\u8bf7\u6c42\u4e3b\u4f53");
        return baseResponse;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.BAD_GATEWAY)
    public BaseResponse<?> handleNoHandlerFoundException(NoHandlerFoundException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        HttpStatus status = HttpStatus.BAD_GATEWAY;
        baseResponse.setStatus(Integer.valueOf(status.value()));
        baseResponse.setMessage(status.getReasonPhrase());
        return baseResponse;
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public BaseResponse<?> handleUploadSizeExceededException(MaxUploadSizeExceededException e) {
        BaseResponse response = this.handleBaseException((Throwable)e);
        response.setStatus(Integer.valueOf(HttpStatus.BAD_REQUEST.value()));
        response.setMessage("\u5f53\u524d\u8bf7\u6c42\u8d85\u51fa\u6700\u5927\u9650\u5236\uff1a" + e.getMaxUploadSize() + " bytes");
        return response;
    }

    @ExceptionHandler(value={AbstractHaloException.class})
    public ResponseEntity<BaseResponse<?>> handleHaloException(AbstractHaloException e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        baseResponse.setStatus(Integer.valueOf(e.getStatus().value()));
        baseResponse.setData(e.getErrorData());
        return new ResponseEntity((Object)baseResponse, e.getStatus());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public BaseResponse<?> handleGlobalException(Exception e) {
        BaseResponse baseResponse = this.handleBaseException((Throwable)e);
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        baseResponse.setStatus(Integer.valueOf(status.value()));
        baseResponse.setMessage(status.getReasonPhrase());
        return baseResponse;
    }

    private <T> BaseResponse<T> handleBaseException(Throwable t) {
        Assert.notNull((Object)t, (String)"Throwable must not be null");
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setMessage(t.getMessage());
        log.error("Captured an exception:", t);
        if (log.isDebugEnabled()) {
            baseResponse.setDevMessage(ExceptionUtils.getStackTrace((Throwable)t));
        }
        return baseResponse;
    }
}

