/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.utils.JsonUtils;
import run.halo.app.utils.ServletUtils;

@Aspect
@Component
public class ControllerLogAop {
    private static final Logger log = LoggerFactory.getLogger(ControllerLogAop.class);

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController)")
    public void restController() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Controller)")
    public void controller() {
    }

    @Around(value="controller() || restController()")
    public Object controller(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method == null || !log.isDebugEnabled()) {
            return joinPoint.proceed();
        }
        String className = joinPoint.getTarget().getClass().getSimpleName();
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        StopWatch watch = new StopWatch(request.getRequestURI());
        watch.start("PrintRequest");
        this.printRequestLog(request, className, methodName, args);
        watch.stop();
        watch.start(className + "#" + methodName);
        Object returnObj = joinPoint.proceed();
        watch.stop();
        watch.start("PrintResponse");
        this.printResponseLog(request, className, methodName, returnObj);
        watch.stop();
        if (log.isDebugEnabled()) {
            log.debug("Usage:\n{}", (Object)watch.prettyPrint());
        }
        return returnObj;
    }

    private void printRequestLog(HttpServletRequest request, String clazzName, String methodName, Object[] args) throws JsonProcessingException {
        log.debug("Request URL: [{}], URI: [{}], Request Method: [{}], IP: [{}]", new Object[]{request.getRequestURL(), request.getRequestURI(), request.getMethod(), ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0])});
        if (args == null || !log.isDebugEnabled()) {
            return;
        }
        boolean shouldNotLog = false;
        for (Object arg : args) {
            if (arg != null && !(arg instanceof HttpServletRequest) && !(arg instanceof HttpServletResponse) && !(arg instanceof MultipartFile) && !arg.getClass().isAssignableFrom(MultipartFile[].class)) continue;
            shouldNotLog = true;
            break;
        }
        if (!shouldNotLog) {
            String requestBody = JsonUtils.objectToJson((Object)args);
            log.debug("{}.{} Parameters: [{}]", new Object[]{clazzName, methodName, requestBody});
        }
    }

    private void printResponseLog(HttpServletRequest request, String className, String methodName, Object returnObj) throws JsonProcessingException {
        if (log.isDebugEnabled()) {
            String returnData = "";
            if (returnObj != null) {
                if (returnObj instanceof ResponseEntity) {
                    ResponseEntity responseEntity = (ResponseEntity)returnObj;
                    if (responseEntity.getBody() instanceof Resource) {
                        returnData = "[ BINARY DATA ]";
                    } else if (responseEntity.getBody() != null) {
                        returnData = this.toString(responseEntity.getBody());
                    }
                } else {
                    returnData = this.toString(returnObj);
                }
            }
            log.debug("{}.{} Response: [{}]", new Object[]{className, methodName, returnData});
        }
    }

    @NonNull
    private String toString(@NonNull Object obj) throws JsonProcessingException {
        Assert.notNull((Object)obj, (String)"Return object must not be null");
        String toString = obj.getClass().isAssignableFrom(byte[].class) && obj instanceof Resource ? "[ BINARY DATA ]" : JsonUtils.objectToJson((Object)obj);
        return toString;
    }
}

