/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core.freemarker.tag;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import run.halo.app.service.CategoryService;
import run.halo.app.service.PostCategoryService;

@Component
public class CategoryTagDirective
implements TemplateDirectiveModel {
    private final CategoryService categoryService;
    private final PostCategoryService postCategoryService;

    public CategoryTagDirective(Configuration configuration, CategoryService categoryService, PostCategoryService postCategoryService) {
        this.categoryService = categoryService;
        this.postCategoryService = postCategoryService;
        configuration.setSharedVariable("categoryTag", (TemplateModel)this);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_25);
        if (params.containsKey("method")) {
            String method;
            switch (method = params.get("method").toString()) {
                case "list": {
                    env.setVariable("categories", builder.build().wrap((Object)this.postCategoryService.listCategoryWithPostCountDto(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"priority"}))));
                    break;
                }
                case "tree": {
                    env.setVariable("categories", builder.build().wrap((Object)this.categoryService.listAsTree(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"priority"}))));
                    break;
                }
                case "listByPostId": {
                    Integer postId = Integer.parseInt(params.get("postId").toString());
                    List categories = this.postCategoryService.listCategoriesBy(postId);
                    env.setVariable("categories", builder.build().wrap((Object)this.categoryService.convertTo(categories)));
                    break;
                }
                case "count": {
                    env.setVariable("count", builder.build().wrap((Object)this.categoryService.count()));
                    break;
                }
            }
        }
        body.render(env.getOut());
    }
}

