/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core.freemarker.tag;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import run.halo.app.service.LinkService;

@Component
public class LinkTagDirective
implements TemplateDirectiveModel {
    private final LinkService linkService;

    public LinkTagDirective(Configuration configuration, LinkService linkService) {
        this.linkService = linkService;
        configuration.setSharedVariable("linkTag", (TemplateModel)this);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_25);
        if (params.containsKey("method")) {
            String method;
            switch (method = params.get("method").toString()) {
                case "list": {
                    env.setVariable("links", builder.build().wrap((Object)this.linkService.listAll()));
                    break;
                }
                case "listByRandom": {
                    env.setVariable("links", builder.build().wrap((Object)this.linkService.listAllByRandom()));
                    break;
                }
                case "listTeams": {
                    env.setVariable("teams", builder.build().wrap((Object)this.linkService.listTeamVos(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}))));
                    break;
                }
                case "listTeamsByRandom": {
                    env.setVariable("teams", builder.build().wrap((Object)this.linkService.listTeamVosByRandom(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}))));
                    break;
                }
                case "count": {
                    env.setVariable("count", builder.build().wrap((Object)this.linkService.count()));
                    break;
                }
            }
        }
        body.render(env.getOut());
    }
}

