/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core.freemarker.tag;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import run.halo.app.model.properties.PrimaryProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.service.MenuService;
import run.halo.app.service.OptionService;

@Component
public class MenuTagDirective
implements TemplateDirectiveModel {
    private static final String METHOD_KEY = "method";
    private final MenuService menuService;
    private final OptionService optionService;

    public MenuTagDirective(Configuration configuration, MenuService menuService, OptionService optionService) {
        this.menuService = menuService;
        this.optionService = optionService;
        configuration.setSharedVariable("menuTag", (TemplateModel)this);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_25);
        if (params.containsKey(METHOD_KEY)) {
            String method;
            switch (method = params.get(METHOD_KEY).toString()) {
                case "list": {
                    String listTeam = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.DEFAULT_MENU_TEAM, String.class, (Object)"");
                    env.setVariable("menus", builder.build().wrap((Object)this.menuService.listByTeam(listTeam, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"priority"}))));
                    break;
                }
                case "tree": {
                    String treeTeam = (String)this.optionService.getByPropertyOrDefault((PropertyEnum)PrimaryProperties.DEFAULT_MENU_TEAM, String.class, (Object)"");
                    env.setVariable("menus", builder.build().wrap((Object)this.menuService.listByTeamAsTree(treeTeam, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"priority"}))));
                    break;
                }
                case "listTeams": {
                    env.setVariable("teams", builder.build().wrap((Object)this.menuService.listTeamVos(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"priority"}))));
                    break;
                }
                case "listByTeam": {
                    String team = params.get("team").toString();
                    env.setVariable("menus", builder.build().wrap((Object)this.menuService.listByTeam(team, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"priority"}))));
                    break;
                }
                case "treeByTeam": {
                    String treeTeamParam = params.get("team").toString();
                    env.setVariable("menus", builder.build().wrap((Object)this.menuService.listByTeamAsTree(treeTeamParam, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"priority"}))));
                    break;
                }
                case "count": {
                    env.setVariable("count", builder.build().wrap((Object)this.menuService.count()));
                    break;
                }
            }
        }
        body.render(env.getOut());
    }
}

