/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core.freemarker.tag;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.stereotype.Component;
import run.halo.app.model.support.Pagination;
import run.halo.app.model.support.RainbowPage;
import run.halo.app.service.OptionService;
import run.halo.app.utils.HaloUtils;

@Component
public class PaginationTagDirective
implements TemplateDirectiveModel {
    private final OptionService optionService;

    public PaginationTagDirective(Configuration configuration, OptionService optionService) {
        this.optionService = optionService;
        configuration.setSharedVariable("paginationTag", (TemplateModel)this);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_25);
        if (params.containsKey("method")) {
            String method = params.get("method").toString();
            int page = Integer.parseInt(params.get("page").toString());
            int total = Integer.parseInt(params.get("total").toString());
            int display = Integer.parseInt(params.get("display").toString());
            Pagination pagination = new Pagination();
            StringBuilder nextPageFullPath = new StringBuilder();
            StringBuilder prevPageFullPath = new StringBuilder();
            if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
                nextPageFullPath.append(this.optionService.getBlogBaseUrl());
                prevPageFullPath.append(this.optionService.getBlogBaseUrl());
            }
            int[] rainbow = HaloUtils.rainbow((int)(page + 1), (int)total, (int)display);
            ArrayList<RainbowPage> rainbowPages = new ArrayList<RainbowPage>();
            StringBuilder fullPath = new StringBuilder();
            if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
                fullPath.append(this.optionService.getBlogBaseUrl());
            }
            String pathSuffix = this.optionService.getPathSuffix();
            switch (method) {
                case "index": {
                    nextPageFullPath.append("/page/").append(page + 2).append(pathSuffix);
                    if (page == 1) {
                        prevPageFullPath.append("/");
                    } else {
                        prevPageFullPath.append("/page/").append(page).append(pathSuffix);
                    }
                    fullPath.append("/page/");
                    for (int current : rainbow) {
                        RainbowPage rainbowPage = new RainbowPage();
                        rainbowPage.setPage(Integer.valueOf(current));
                        rainbowPage.setFullPath(fullPath.toString() + current + pathSuffix);
                        rainbowPage.setIsCurrent(Boolean.valueOf(page + 1 == current));
                        rainbowPages.add(rainbowPage);
                    }
                    break;
                }
                case "archives": {
                    nextPageFullPath.append("/").append(this.optionService.getArchivesPrefix());
                    prevPageFullPath.append("/").append(this.optionService.getArchivesPrefix());
                    nextPageFullPath.append("/page/").append(page + 2).append(pathSuffix);
                    if (page == 1) {
                        prevPageFullPath.append(pathSuffix);
                    } else {
                        prevPageFullPath.append("/page/").append(page).append(pathSuffix);
                    }
                    fullPath.append("/").append(this.optionService.getArchivesPrefix());
                    fullPath.append("/page/");
                    for (int current : rainbow) {
                        RainbowPage rainbowPage = new RainbowPage();
                        rainbowPage.setPage(Integer.valueOf(current));
                        rainbowPage.setFullPath(fullPath.toString() + current + pathSuffix);
                        rainbowPage.setIsCurrent(Boolean.valueOf(page + 1 == current));
                        rainbowPages.add(rainbowPage);
                    }
                    break;
                }
                case "search": {
                    String keyword = params.get("keyword").toString();
                    nextPageFullPath.append("/").append("search");
                    prevPageFullPath.append("/").append("search");
                    nextPageFullPath.append("/page/").append(page + 2).append(pathSuffix).append("?keyword=").append(keyword);
                    if (page == 1) {
                        prevPageFullPath.append(pathSuffix).append("?keyword=").append(keyword);
                    } else {
                        prevPageFullPath.append("/page/").append(page).append(pathSuffix).append("?keyword=").append(keyword);
                    }
                    fullPath.append("/").append("search");
                    fullPath.append("/page/");
                    for (int current : rainbow) {
                        RainbowPage rainbowPage = new RainbowPage();
                        rainbowPage.setPage(Integer.valueOf(current));
                        rainbowPage.setFullPath(fullPath.toString() + current + pathSuffix + "?keyword=" + keyword);
                        rainbowPage.setIsCurrent(Boolean.valueOf(page + 1 == current));
                        rainbowPages.add(rainbowPage);
                    }
                    break;
                }
                case "tagPosts": {
                    String tagSlug = params.get("slug").toString();
                    nextPageFullPath.append("/").append(this.optionService.getTagsPrefix()).append("/").append(tagSlug);
                    prevPageFullPath.append("/").append(this.optionService.getTagsPrefix()).append("/").append(tagSlug);
                    nextPageFullPath.append("/page/").append(page + 2).append(pathSuffix);
                    if (page == 1) {
                        prevPageFullPath.append(pathSuffix);
                    } else {
                        prevPageFullPath.append("/page/").append(page).append(pathSuffix);
                    }
                    fullPath.append("/").append(this.optionService.getTagsPrefix()).append("/").append(tagSlug);
                    fullPath.append("/page/");
                    for (int current : rainbow) {
                        RainbowPage rainbowPage = new RainbowPage();
                        rainbowPage.setPage(Integer.valueOf(current));
                        rainbowPage.setFullPath(fullPath.toString() + current + pathSuffix);
                        rainbowPage.setIsCurrent(Boolean.valueOf(page + 1 == current));
                        rainbowPages.add(rainbowPage);
                    }
                    break;
                }
                case "categoryPosts": {
                    String categorySlug = params.get("slug").toString();
                    nextPageFullPath.append("/").append(this.optionService.getCategoriesPrefix()).append("/").append(categorySlug);
                    prevPageFullPath.append("/").append(this.optionService.getCategoriesPrefix()).append("/").append(categorySlug);
                    nextPageFullPath.append("/page/").append(page + 2).append(pathSuffix);
                    if (page == 1) {
                        prevPageFullPath.append(pathSuffix);
                    } else {
                        prevPageFullPath.append("/page/").append(page).append(pathSuffix);
                    }
                    fullPath.append("/").append(this.optionService.getCategoriesPrefix()).append("/").append(categorySlug);
                    fullPath.append("/page/");
                    for (int current : rainbow) {
                        RainbowPage rainbowPage = new RainbowPage();
                        rainbowPage.setPage(Integer.valueOf(current));
                        rainbowPage.setFullPath(fullPath.toString() + current + pathSuffix);
                        rainbowPage.setIsCurrent(Boolean.valueOf(page + 1 == current));
                        rainbowPages.add(rainbowPage);
                    }
                    break;
                }
                case "photos": {
                    nextPageFullPath.append("/").append(this.optionService.getPhotosPrefix());
                    prevPageFullPath.append("/").append(this.optionService.getPhotosPrefix());
                    nextPageFullPath.append("/page/").append(page + 2).append(pathSuffix);
                    if (page == 1) {
                        prevPageFullPath.append(pathSuffix);
                    } else {
                        prevPageFullPath.append("/page/").append(page).append(pathSuffix);
                    }
                    fullPath.append("/").append(this.optionService.getPhotosPrefix());
                    fullPath.append("/page/");
                    for (int current : rainbow) {
                        RainbowPage rainbowPage = new RainbowPage();
                        rainbowPage.setPage(Integer.valueOf(current));
                        rainbowPage.setFullPath(fullPath.toString() + current + pathSuffix);
                        rainbowPage.setIsCurrent(Boolean.valueOf(page + 1 == current));
                        rainbowPages.add(rainbowPage);
                    }
                    break;
                }
                case "journals": {
                    nextPageFullPath.append("/").append(this.optionService.getJournalsPrefix());
                    prevPageFullPath.append("/").append(this.optionService.getJournalsPrefix());
                    nextPageFullPath.append("/page/").append(page + 2).append(pathSuffix);
                    if (page == 1) {
                        prevPageFullPath.append(pathSuffix);
                    } else {
                        prevPageFullPath.append("/page/").append(page).append(pathSuffix);
                    }
                    fullPath.append("/").append(this.optionService.getJournalsPrefix());
                    fullPath.append("/page/");
                    for (int current : rainbow) {
                        RainbowPage rainbowPage = new RainbowPage();
                        rainbowPage.setPage(Integer.valueOf(current));
                        rainbowPage.setFullPath(fullPath.toString() + current + pathSuffix);
                        rainbowPage.setIsCurrent(Boolean.valueOf(page + 1 == current));
                        rainbowPages.add(rainbowPage);
                    }
                    break;
                }
            }
            pagination.setNextPageFullPath(nextPageFullPath.toString());
            pagination.setPrevPageFullPath(prevPageFullPath.toString());
            pagination.setRainbowPages(rainbowPages);
            pagination.setHasNext(Boolean.valueOf(total != page + 1));
            pagination.setHasPrev(Boolean.valueOf(page != 0));
            env.setVariable("pagination", builder.build().wrap((Object)pagination));
        }
        body.render(env.getOut());
    }
}

