/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core.freemarker.tag;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import run.halo.app.service.PhotoService;

@Component
public class PhotoTagDirective
implements TemplateDirectiveModel {
    private final PhotoService photoService;

    public PhotoTagDirective(Configuration configuration, PhotoService photoService) {
        this.photoService = photoService;
        configuration.setSharedVariable("photoTag", (TemplateModel)this);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_25);
        if (params.containsKey("method")) {
            String method;
            switch (method = params.get("method").toString()) {
                case "list": {
                    env.setVariable("photos", builder.build().wrap((Object)this.photoService.listAll()));
                    break;
                }
                case "listTeams": {
                    env.setVariable("teams", builder.build().wrap((Object)this.photoService.listTeamVos(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}))));
                    break;
                }
                case "listByTeam": {
                    String team = params.get("team").toString();
                    env.setVariable("photos", builder.build().wrap((Object)this.photoService.listByTeam(team, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}))));
                    break;
                }
                case "count": {
                    env.setVariable("count", builder.build().wrap((Object)this.photoService.count()));
                    break;
                }
            }
        }
        body.render(env.getOut());
    }
}

