/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core.freemarker.tag;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.service.PostCategoryService;
import run.halo.app.service.PostService;
import run.halo.app.service.PostTagService;
import run.halo.app.service.assembler.PostRenderAssembler;

@Component
public class PostTagDirective
implements TemplateDirectiveModel {
    private final PostService postService;
    private final PostRenderAssembler postRenderAssembler;
    private final PostTagService postTagService;
    private final PostCategoryService postCategoryService;

    public PostTagDirective(Configuration configuration, PostService postService, PostRenderAssembler postRenderAssembler, PostTagService postTagService, PostCategoryService postCategoryService) {
        this.postService = postService;
        this.postRenderAssembler = postRenderAssembler;
        this.postTagService = postTagService;
        this.postCategoryService = postCategoryService;
        configuration.setSharedVariable("postTag", (TemplateModel)this);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_25);
        if (params.containsKey("method")) {
            String method;
            switch (method = params.get("method").toString()) {
                case "latest": {
                    int top = Integer.parseInt(params.get("top").toString());
                    env.setVariable("posts", builder.build().wrap((Object)this.postRenderAssembler.convertToListVo(this.postService.listLatest(top))));
                    break;
                }
                case "count": {
                    env.setVariable("count", builder.build().wrap((Object)this.postService.countByStatus(PostStatus.PUBLISHED)));
                    break;
                }
                case "archiveYear": {
                    env.setVariable("archives", builder.build().wrap((Object)this.postService.listYearArchives()));
                    break;
                }
                case "archiveMonth": {
                    env.setVariable("archives", builder.build().wrap((Object)this.postService.listMonthArchives()));
                    break;
                }
                case "archive": {
                    String type = params.get("type").toString();
                    env.setVariable("archives", builder.build().wrap((Object)("year".equals(type) ? this.postService.listYearArchives() : this.postService.listMonthArchives())));
                    break;
                }
                case "listByCategoryId": {
                    Integer categoryId = Integer.parseInt(params.get("categoryId").toString());
                    env.setVariable("posts", builder.build().wrap((Object)this.postRenderAssembler.convertToListVo(this.postCategoryService.listPostBy(categoryId, PostStatus.PUBLISHED))));
                    break;
                }
                case "listByCategorySlug": {
                    String categorySlug = params.get("categorySlug").toString();
                    List posts = this.postCategoryService.listPostBy(categorySlug, PostStatus.PUBLISHED);
                    env.setVariable("posts", builder.build().wrap((Object)this.postRenderAssembler.convertToListVo(posts)));
                    break;
                }
                case "listByTagId": {
                    Integer tagId = Integer.parseInt(params.get("tagId").toString());
                    env.setVariable("posts", builder.build().wrap((Object)this.postRenderAssembler.convertToListVo(this.postTagService.listPostsBy(tagId, PostStatus.PUBLISHED))));
                    break;
                }
                case "listByTagSlug": {
                    String tagSlug = params.get("tagSlug").toString();
                    env.setVariable("posts", builder.build().wrap((Object)this.postRenderAssembler.convertToListVo(this.postTagService.listPostsBy(tagSlug, PostStatus.PUBLISHED))));
                    break;
                }
            }
        }
        body.render(env.getOut());
    }
}

