/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.core.freemarker.tag;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import run.halo.app.service.PostTagService;
import run.halo.app.service.TagService;

@Component
public class TagTagDirective
implements TemplateDirectiveModel {
    private final TagService tagService;
    private final PostTagService postTagService;

    public TagTagDirective(Configuration configuration, TagService tagService, PostTagService postTagService) {
        this.tagService = tagService;
        this.postTagService = postTagService;
        configuration.setSharedVariable("tagTag", (TemplateModel)this);
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_25);
        if (params.containsKey("method")) {
            String method;
            switch (method = params.get("method").toString()) {
                case "list": {
                    env.setVariable("tags", builder.build().wrap((Object)this.postTagService.listTagWithCountDtos(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}))));
                    break;
                }
                case "listByPostId": {
                    Integer postId = Integer.parseInt(params.get("postId").toString());
                    List tags = this.postTagService.listTagsBy(postId);
                    env.setVariable("tags", builder.build().wrap((Object)this.tagService.convertTo(tags)));
                    break;
                }
                case "count": {
                    env.setVariable("count", builder.build().wrap((Object)this.tagService.count()));
                    break;
                }
            }
        }
        body.render(env.getOut());
    }
}

